/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.openapidiff.core.compare;

import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.headers.Header;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import org.openapitools.openapidiff.core.compare.OpenApiDiff;
import org.openapitools.openapidiff.core.compare.ReferenceDiffCache;
import org.openapitools.openapidiff.core.model.ChangedHeader;
import org.openapitools.openapidiff.core.model.DiffContext;
import org.openapitools.openapidiff.core.utils.ChangedUtils;
import org.openapitools.openapidiff.core.utils.RefPointer;
import org.openapitools.openapidiff.core.utils.RefType;

public class HeaderDiff
extends ReferenceDiffCache<Header, ChangedHeader> {
    private static final RefPointer<Header> refPointer = new RefPointer(RefType.HEADERS);
    private final OpenApiDiff openApiDiff;
    private final Components leftComponents;
    private final Components rightComponents;

    public HeaderDiff(OpenApiDiff openApiDiff) {
        this.openApiDiff = openApiDiff;
        this.leftComponents = openApiDiff.getOldSpecOpenApi() != null ? openApiDiff.getOldSpecOpenApi().getComponents() : null;
        this.rightComponents = openApiDiff.getNewSpecOpenApi() != null ? openApiDiff.getNewSpecOpenApi().getComponents() : null;
    }

    public Optional<ChangedHeader> diff(Header left, Header right, DiffContext context) {
        return this.cachedDiff(new HashSet<String>(), left, right, left.get$ref(), right.get$ref(), context);
    }

    @Override
    protected Optional<ChangedHeader> computeDiff(HashSet<String> refSet, Header left, Header right, DiffContext context) {
        left = refPointer.resolveRef(this.leftComponents, left, left.get$ref());
        right = refPointer.resolveRef(this.rightComponents, right, right.get$ref());
        ChangedHeader changedHeader = new ChangedHeader(left, right, context).setRequired(this.getBooleanDiff(left.getRequired(), right.getRequired())).setDeprecated(!Boolean.TRUE.equals(left.getDeprecated()) && Boolean.TRUE.equals(right.getDeprecated())).setStyle(!Objects.equals(left.getStyle(), right.getStyle())).setExplode(this.getBooleanDiff(left.getExplode(), right.getExplode()));
        this.openApiDiff.getMetadataDiff().diff(left.getDescription(), right.getDescription(), context).ifPresent(changedHeader::setDescription);
        this.openApiDiff.getSchemaDiff().diff(new HashSet<String>(), left.getSchema(), right.getSchema(), context.copyWithRequired(true)).ifPresent(changedHeader::setSchema);
        this.openApiDiff.getContentDiff().diff(left.getContent(), right.getContent(), context).ifPresent(changedHeader::setContent);
        this.openApiDiff.getExtensionsDiff().diff(left.getExtensions(), right.getExtensions(), context).ifPresent(changedHeader::setExtensions);
        return ChangedUtils.isChanged(changedHeader);
    }

    private boolean getBooleanDiff(Boolean left, Boolean right) {
        boolean rightRequired;
        boolean leftRequired = Optional.ofNullable(left).orElse(Boolean.FALSE);
        return leftRequired != (rightRequired = Optional.ofNullable(right).orElse(Boolean.FALSE).booleanValue());
    }
}

