/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.openapidiff.core.compare;

import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import org.openapitools.openapidiff.core.compare.MapKeyDiff;
import org.openapitools.openapidiff.core.compare.OpenApiDiff;
import org.openapitools.openapidiff.core.model.ChangedContent;
import org.openapitools.openapidiff.core.model.ChangedMediaType;
import org.openapitools.openapidiff.core.model.DiffContext;
import org.openapitools.openapidiff.core.utils.ChangedUtils;

public class ContentDiff {
    private final OpenApiDiff openApiDiff;

    public ContentDiff(OpenApiDiff openApiDiff) {
        this.openApiDiff = openApiDiff;
    }

    public Optional<ChangedContent> diff(Content left, Content right, DiffContext context) {
        MapKeyDiff mediaTypeDiff = MapKeyDiff.diff(left, right);
        List sharedMediaTypes = mediaTypeDiff.getSharedKey();
        LinkedHashMap<String, ChangedMediaType> changedMediaTypes = new LinkedHashMap<String, ChangedMediaType>();
        for (String mediaTypeKey : sharedMediaTypes) {
            MediaType oldMediaType = (MediaType)left.get((Object)mediaTypeKey);
            MediaType newMediaType = (MediaType)right.get((Object)mediaTypeKey);
            ChangedMediaType changedMediaType = new ChangedMediaType(oldMediaType.getSchema(), newMediaType.getSchema(), context);
            this.openApiDiff.getSchemaDiff().diff(new HashSet<String>(), oldMediaType.getSchema(), newMediaType.getSchema(), context.copyWithRequired(true)).ifPresent(changedMediaType::setSchema);
            if (ChangedUtils.isUnchanged(changedMediaType)) continue;
            changedMediaTypes.put(mediaTypeKey, changedMediaType);
        }
        return ChangedUtils.isChanged(new ChangedContent(left, right, context).setIncreased(mediaTypeDiff.getIncreased()).setMissing(mediaTypeDiff.getMissing()).setChanged(changedMediaTypes));
    }
}

