/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.openapidiff.core.compare;

import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.openapitools.openapidiff.core.compare.MapKeyDiff;
import org.openapitools.openapidiff.core.compare.OpenApiDiff;
import org.openapitools.openapidiff.core.model.ChangedApiResponse;
import org.openapitools.openapidiff.core.model.ChangedResponse;
import org.openapitools.openapidiff.core.model.DiffContext;
import org.openapitools.openapidiff.core.utils.ChangedUtils;

public class ApiResponseDiff {
    private final OpenApiDiff openApiDiff;

    public ApiResponseDiff(OpenApiDiff openApiDiff) {
        this.openApiDiff = openApiDiff;
    }

    public Optional<ChangedApiResponse> diff(@Nullable ApiResponses left, @Nullable ApiResponses right, DiffContext context) {
        MapKeyDiff responseMapKeyDiff = MapKeyDiff.diff(left, right);
        List sharedResponseCodes = responseMapKeyDiff.getSharedKey();
        LinkedHashMap<String, ChangedResponse> resps = new LinkedHashMap<String, ChangedResponse>();
        for (String responseCode : sharedResponseCodes) {
            this.openApiDiff.getResponseDiff().diff(left != null ? (ApiResponse)left.get((Object)responseCode) : null, right != null ? (ApiResponse)right.get((Object)responseCode) : null, context).ifPresent(changedResponse -> resps.put(responseCode, (ChangedResponse)changedResponse));
        }
        ChangedApiResponse changedApiResponse = new ChangedApiResponse(left, right, context).setIncreased(responseMapKeyDiff.getIncreased()).setMissing(responseMapKeyDiff.getMissing()).setChanged(resps);
        this.openApiDiff.getExtensionsDiff().diff(left != null ? left.getExtensions() : null, right != null ? right.getExtensions() : null, context).ifPresent(changedApiResponse::setExtensions);
        return ChangedUtils.isChanged(changedApiResponse);
    }
}

