/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.openapidiff.core;

import io.swagger.parser.OpenAPIParser;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.parser.core.models.AuthorizationValue;
import io.swagger.v3.parser.core.models.ParseOptions;
import java.io.File;
import java.util.List;
import org.openapitools.openapidiff.core.compare.OpenApiDiff;
import org.openapitools.openapidiff.core.model.ChangedOpenApi;

public class OpenApiCompare {
    private static final OpenAPIParser openApiParser = new OpenAPIParser();
    private static final ParseOptions options = new ParseOptions();

    public static ChangedOpenApi fromContents(String oldContent, String newContent) {
        return OpenApiCompare.fromContents(oldContent, newContent, null);
    }

    public static ChangedOpenApi fromContents(String oldContent, String newContent, List<AuthorizationValue> auths) {
        return OpenApiCompare.fromSpecifications(OpenApiCompare.readContent(oldContent, auths), OpenApiCompare.readContent(newContent, auths));
    }

    public static ChangedOpenApi fromFiles(File oldFile, File newFile) {
        return OpenApiCompare.fromFiles(oldFile, newFile, null);
    }

    public static ChangedOpenApi fromFiles(File oldFile, File newFile, List<AuthorizationValue> auths) {
        return OpenApiCompare.fromLocations(oldFile.getAbsolutePath(), newFile.getAbsolutePath(), auths);
    }

    public static ChangedOpenApi fromLocations(String oldLocation, String newLocation) {
        return OpenApiCompare.fromLocations(oldLocation, newLocation, null);
    }

    public static ChangedOpenApi fromLocations(String oldLocation, String newLocation, List<AuthorizationValue> auths) {
        return OpenApiCompare.fromSpecifications(OpenApiCompare.readLocation(oldLocation, auths), OpenApiCompare.readLocation(newLocation, auths));
    }

    public static ChangedOpenApi fromSpecifications(OpenAPI oldSpec, OpenAPI newSpec) {
        return OpenApiDiff.compare(OpenApiCompare.notNull(oldSpec, "old"), OpenApiCompare.notNull(newSpec, "new"));
    }

    private static OpenAPI notNull(OpenAPI spec, String type) {
        if (spec == null) {
            throw new RuntimeException(String.format("Cannot read %s OpenAPI spec", type));
        }
        return spec;
    }

    private static OpenAPI readContent(String content, List<AuthorizationValue> auths) {
        return openApiParser.readContents(content, auths, options).getOpenAPI();
    }

    private static OpenAPI readLocation(String location, List<AuthorizationValue> auths) {
        return openApiParser.readLocation(location, auths, options).getOpenAPI();
    }

    static {
        options.setResolve(true);
    }
}

