/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.junit;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.hamcrest.Description;
import org.hamcrest.StringDescription;
import org.onlab.junit.TestUtils;

public class UtilityClassChecker {
    private String failureReason = "";

    private boolean isProperlyDefinedUtilityClass(Class<?> clazz) {
        if (!Modifier.isFinal(clazz.getModifiers())) {
            this.failureReason = "a class that is not final";
            return false;
        }
        Constructor<?>[] constructors = clazz.getDeclaredConstructors();
        if (constructors.length != 1) {
            this.failureReason = "a class with more than one constructor";
            return false;
        }
        Constructor<?> constructor = constructors[0];
        if (constructor.isAccessible()) {
            this.failureReason = "a class with an accessible default constructor";
            return false;
        }
        if (!Modifier.isPrivate(constructor.getModifiers())) {
            this.failureReason = "a class with a default constructor that is not private";
            return false;
        }
        for (Method method : clazz.getMethods()) {
            if (!method.getDeclaringClass().equals(clazz) || Modifier.isStatic(method.getModifiers())) continue;
            this.failureReason = "a class with one or more non-static methods";
            return false;
        }
        try {
            Object newObject = TestUtils.callConstructor(constructor);
            if (newObject == null) {
                this.failureReason = "could not instantiate a new object";
                return false;
            }
        }
        catch (TestUtils.TestUtilsException e) {
            this.failureReason = "could not instantiate a new object";
            return false;
        }
        return true;
    }

    public void describeMismatch(Description description) {
        description.appendText(this.failureReason);
    }

    public void describeTo(Description description) {
        description.appendText("a properly defined utility class");
    }

    public static void assertThatClassIsUtility(Class<?> clazz) {
        UtilityClassChecker checker = new UtilityClassChecker();
        if (!checker.isProperlyDefinedUtilityClass(clazz)) {
            StringDescription toDescription = new StringDescription();
            StringDescription mismatchDescription = new StringDescription();
            checker.describeTo((Description)toDescription);
            checker.describeMismatch((Description)mismatchDescription);
            String reason = "\nExpected: is \"" + toDescription.toString() + "\"\n    but : was \"" + mismatchDescription.toString() + "\"";
            throw new AssertionError((Object)reason);
        }
    }
}

