/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.junit;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public final class TestUtils {
    public static <T, U> void setField(T subject, String fieldName, U value) throws TestUtilsException {
        try {
            for (Class<?> clazz = subject instanceof Class ? (Class<?>)subject : subject.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
                try {
                    Field field = clazz.getDeclaredField(fieldName);
                    field.setAccessible(true);
                    field.set(subject, value);
                    break;
                }
                catch (NoSuchFieldException ex) {
                    if (clazz != clazz.getSuperclass()) {
                        continue;
                    }
                    break;
                }
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException e) {
            throw new TestUtilsException("setField failed", e);
        }
    }

    public static <T, U> U getField(T subject, String fieldName) throws TestUtilsException {
        try {
            NoSuchFieldException exception = null;
            for (Class<?> clazz = subject instanceof Class ? (Class<?>)subject : subject.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
                try {
                    Field field = clazz.getDeclaredField(fieldName);
                    field.setAccessible(true);
                    Object result = field.get(subject);
                    return (U)result;
                }
                catch (NoSuchFieldException e) {
                    exception = e;
                    if (clazz == clazz.getSuperclass()) break;
                    continue;
                }
            }
            throw new TestUtilsException("Field not found. " + fieldName, exception);
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException e) {
            throw new TestUtilsException("getField failed", e);
        }
    }

    public static <T, U> U callMethod(T subject, String methodName, Class<?>[] paramTypes, Object ... args) throws TestUtilsException {
        try {
            Class<?> clazz = subject.getClass();
            Method method = paramTypes == null || paramTypes.length == 0 ? clazz.getDeclaredMethod(methodName, new Class[0]) : clazz.getDeclaredMethod(methodName, paramTypes);
            method.setAccessible(true);
            Object result = method.invoke(subject, args);
            return (U)result;
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new TestUtilsException("callMethod failed", e);
        }
    }

    public static <T, U> U callMethod(T subject, String methodName, Class<?> paramType, Object arg) throws TestUtilsException {
        return TestUtils.callMethod(subject, methodName, new Class[]{paramType}, arg);
    }

    public static <T> T callConstructor(Constructor<T> constructor) throws TestUtilsException {
        try {
            constructor.setAccessible(true);
            return constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException error) {
            throw new TestUtilsException("callConstructor failed", error);
        }
    }

    private TestUtils() {
    }

    public static class TestUtilsException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public TestUtilsException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

