/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.junit;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.List;
import java.util.Random;
import org.junit.Assert;

public final class TestTools {
    private static final Random RANDOM = new Random();

    private TestTools() {
    }

    public static void print(String msg) {
        System.out.print(msg);
    }

    public static void delay(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            Assert.fail((String)"test interrupted");
        }
    }

    public static long now() {
        return System.currentTimeMillis();
    }

    public static void assertAfter(int delay, int duration, Runnable assertions) {
        Preconditions.checkArgument((delay < duration ? 1 : 0) != 0, (Object)"delay >= duration");
        long start = TestTools.now();
        int step = Math.max(Math.min((duration - delay) / 100, 50), 10);
        if (delay > 0) {
            TestTools.delay(delay);
        }
        while (true) {
            try {
                assertions.run();
            }
            catch (AssertionError e) {
                if (TestTools.now() - start > (long)duration) {
                    throw e;
                }
                TestTools.delay(step);
                continue;
            }
            break;
        }
    }

    public static void assertAfter(int duration, Runnable assertions) {
        TestTools.assertAfter(0, duration, assertions);
    }

    public static List<File> createTestFiles(List<String> paths) throws IOException {
        return TestTools.createTestFiles(paths, 32, 1024);
    }

    public static List<File> createTestFiles(List<String> paths, int minSize, int maxSize) throws IOException {
        ImmutableList.Builder files = ImmutableList.builder();
        for (String p : paths) {
            File f = new File(p);
            if (p.endsWith("/")) {
                if (!f.mkdirs()) continue;
                files.add((Object)f);
                continue;
            }
            Files.createParentDirs((File)f);
            if (!f.createNewFile()) continue;
            TestTools.writeRandomFile(f, minSize, maxSize);
            files.add((Object)f);
        }
        return files.build();
    }

    public static void writeRandomFile(File file, int minSize, int maxSize) throws IOException {
        int size = minSize + (minSize == maxSize ? 0 : RANDOM.nextInt(maxSize - minSize));
        byte[] data = new byte[size];
        TestTools.tweakBytes(RANDOM, data, size / 4);
        Files.write((byte[])data, (File)file);
    }

    public static void tweakBytes(Random random, byte[] data, int count) {
        TestTools.tweakBytes(random, data, count, 0, data.length);
    }

    public static void tweakBytes(Random random, byte[] data, int count, int start, int end) {
        int len = end - start;
        for (int i = 0; i < count; ++i) {
            data[start + random.nextInt((int)len)] = (byte)random.nextInt();
        }
    }

    public static int findAvailablePort(int defaultPort) {
        try {
            ServerSocket socket = new ServerSocket(0);
            socket.setReuseAddress(true);
            int port = socket.getLocalPort();
            socket.close();
            return port;
        }
        catch (IOException ex) {
            return defaultPort;
        }
    }
}

