/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.junit;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.hamcrest.Description;
import org.hamcrest.StringDescription;

public class ImmutableClassChecker {
    private String failureReason = "";

    private boolean isImmutableClass(Class<?> clazz, boolean allowNonFinalClass) {
        if (!allowNonFinalClass && !Modifier.isFinal(clazz.getModifiers())) {
            this.failureReason = "a class that is not final";
            return false;
        }
        for (Field field : clazz.getDeclaredFields()) {
            if (field.getName().startsWith("_") || field.getName().startsWith("$")) continue;
            if (!Modifier.isFinal(field.getModifiers())) {
                this.failureReason = "a field named '" + field.getName() + "' that is not final";
                return false;
            }
            if (Modifier.isPrivate(field.getModifiers()) || Modifier.isStatic(field.getModifiers())) continue;
            this.failureReason = "a field named '" + field.getName() + "' that is not private and is not static";
            return false;
        }
        for (AccessibleObject accessibleObject : clazz.getMethods()) {
            if (!((Method)accessibleObject).getDeclaringClass().equals(clazz) || !((Method)accessibleObject).getName().startsWith("set")) continue;
            this.failureReason = "a class with a setter named '" + ((Method)accessibleObject).getName() + "'";
            return false;
        }
        return true;
    }

    public void describeMismatch(Description description) {
        description.appendText(this.failureReason);
    }

    public void describeTo(Description description) {
        description.appendText("a properly defined immutable class");
    }

    public static void assertThatClassIsImmutable(Class<?> clazz) {
        ImmutableClassChecker checker = new ImmutableClassChecker();
        if (!checker.isImmutableClass(clazz, false)) {
            StringDescription toDescription = new StringDescription();
            StringDescription mismatchDescription = new StringDescription();
            checker.describeTo((Description)toDescription);
            checker.describeMismatch((Description)mismatchDescription);
            String reason = "\nExpected: is \"" + toDescription.toString() + "\"\n    but : was \"" + mismatchDescription.toString() + "\"";
            throw new AssertionError((Object)reason);
        }
    }

    public static void assertThatClassIsImmutableBaseClass(Class<?> clazz) {
        ImmutableClassChecker checker = new ImmutableClassChecker();
        if (!checker.isImmutableClass(clazz, true)) {
            StringDescription toDescription = new StringDescription();
            StringDescription mismatchDescription = new StringDescription();
            checker.describeTo((Description)toDescription);
            checker.describeMismatch((Description)mismatchDescription);
            String reason = "\nExpected: is \"" + toDescription.toString() + "\"\n    but : was \"" + mismatchDescription.toString() + "\"";
            throw new AssertionError((Object)reason);
        }
    }
}

