/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.junit;

import org.junit.Assert;
import org.junit.Test;

public abstract class ExceptionTest {
    protected static final Throwable CAUSE = new RuntimeException("boom");
    protected static final String MESSAGE = "Uh oh.... boom";

    protected abstract Exception getDefault();

    protected abstract Exception getWithMessage();

    protected abstract Exception getWithMessageAndCause();

    @Test
    public void noMessageNoCause() {
        Exception e = this.getDefault();
        Assert.assertEquals((String)"incorrect message", null, (Object)e.getMessage());
        Assert.assertEquals((String)"incorrect cause", null, (Object)e.getCause());
    }

    @Test
    public void withMessage() {
        Exception e = this.getWithMessage();
        Assert.assertEquals((String)"incorrect message", (Object)MESSAGE, (Object)e.getMessage());
        Assert.assertEquals((String)"incorrect cause", null, (Object)e.getCause());
    }

    @Test
    public void withCause() {
        Exception e = this.getWithMessageAndCause();
        Assert.assertEquals((String)"incorrect message", (Object)MESSAGE, (Object)e.getMessage());
        Assert.assertSame((String)"incorrect cause", (Object)CAUSE, (Object)e.getCause());
    }
}

