/*
 * Decompiled with CFR 0.152.
 */
package org.objectledge.maven.plugins.jsc;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.mozilla.javascript.tools.jsc.Main;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JscMojo
extends AbstractMojo {
    private File outputDirectory;
    private File sourceDirectory;
    private String sourceExtension;
    private String packageName;
    private String superClassName;
    private String interfaceNames;
    private boolean debug;
    private int optLevel;
    private String versionNumber;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Log log = this.getLog();
        log.debug((CharSequence)String.format("sourceDirectory : %s\n", this.sourceDirectory));
        log.debug((CharSequence)String.format("sourceExtension : %s\n", this.sourceExtension));
        log.debug((CharSequence)String.format("outputDirectory : %s\n", this.outputDirectory));
        log.debug((CharSequence)String.format("packageName     : %s\n", this.packageName));
        log.debug((CharSequence)String.format("versionNumber   : %s\n", this.versionNumber));
        File f = this.outputDirectory;
        if (!f.exists()) {
            f.mkdirs();
        }
        ArrayList<String> argList = new ArrayList<String>();
        this.appendArguments(argList);
        this.appendSources(argList);
        Main.main((String[])argList.toArray(new String[argList.size()]));
    }

    private void appendArguments(List<String> argList) {
        if (this.packageName != null && this.packageName.length() > 0) {
            argList.add("-package");
            argList.add(this.packageName);
        }
        if (this.superClassName != null && this.superClassName.length() > 0) {
            argList.add("-extends");
            argList.add(this.superClassName);
        }
        if (this.interfaceNames != null && this.interfaceNames.length() > 0) {
            argList.add("-implements");
            argList.add(this.interfaceNames);
        }
        if (this.debug) {
            argList.add("-debug");
        }
        if (this.optLevel != 0) {
            argList.add("-opt");
            argList.add(Integer.toString(this.optLevel));
        }
        if (this.versionNumber != null) {
            argList.add("-version");
            argList.add(this.versionNumber);
        }
        if (this.outputDirectory != null) {
            argList.add("-d");
            argList.add(this.outputDirectory.getAbsolutePath());
        }
    }

    void appendSources(List<String> argList) {
        String[] extensions;
        Collection files;
        if (this.sourceDirectory.isDirectory() && (files = FileUtils.listFiles((File)this.sourceDirectory, (String[])(extensions = this.sourceExtension.split(",")), (boolean)true)) != null) {
            for (File file : files) {
                argList.add(file.toString());
            }
        }
    }
}

