/*
 * Decompiled with CFR 0.152.
 */
package org.nameapi.client.services.nameparser.syntax;

import org.jetbrains.annotations.NotNull;
import org.nameapi.ontology5.cremalang.annotation.GeneratedCode;
import org.nameapi.ontology5.cremalang.lang.Preconditions;

public class NameParserRule {
    @NotNull
    private final String name;
    private final int chance;
    @NotNull
    private final String syntax;

    public NameParserRule(@NotNull String name, int chance, @NotNull String syntax) throws IllegalArgumentException {
        if (chance < 1 || chance > 100) {
            throw new IllegalArgumentException("Chance must be 1-100 but was: " + chance + "!");
        }
        Preconditions.notNullAndNotEmpty((String)syntax, (String)"syntax");
        this.name = name;
        this.chance = chance;
        this.syntax = syntax;
    }

    public String getName() {
        return this.name;
    }

    public int getChance() {
        return this.chance;
    }

    @NotNull
    public String getSyntax() {
        return this.syntax;
    }

    @GeneratedCode
    public String toString() {
        return "NameParserRule{name='" + this.name + '\'' + ", chance=" + this.chance + ", syntax='" + this.syntax + '\'' + '}';
    }

    @GeneratedCode
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NameParserRule that = (NameParserRule)o;
        if (this.chance != that.chance) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        return this.syntax.equals(that.syntax);
    }

    @GeneratedCode
    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.chance;
        result = 31 * result + this.syntax.hashCode();
        return result;
    }
}

