/*
 * Decompiled with CFR 0.152.
 */
package org.nameapi.client.services.nameparser.syntax;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.nameapi.client.services.nameparser.syntax.NameParserRule;

public class RuleCollector {
    private final Set<String> names = new HashSet<String>();
    private final ArrayList<NameParserRule> list = new ArrayList();

    @NotNull
    public RuleCollector add(@NotNull NameParserRule rule) {
        if (this.names.contains(rule.getName())) {
            throw new IllegalStateException("Already added a rule with name >>>" + rule.getName() + "<<<!");
        }
        this.names.add(rule.getName());
        this.list.add(rule);
        return this;
    }

    @NotNull
    public List<NameParserRule> toList() throws IllegalStateException {
        if (this.list.isEmpty()) {
            throw new IllegalStateException("No rules added yet!");
        }
        return ImmutableList.copyOf(this.list);
    }

    @NotNull
    public List<NameParserRule> asList() {
        return this.list;
    }

    public String toString() {
        return "RuleCollector{list=" + this.list + '}';
    }
}

