/*
 * Decompiled with CFR 0.152.
 */
package org.nameapi.client.services.nameparser.syntax;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.nameapi.client.services.nameparser.syntax.NameParserRule;
import org.nameapi.ontology5.cremalang.annotation.Immutable;
import org.nameapi.ontology5.cremalang.lang.Preconditions;

@Immutable
public class NameParserArgument {
    @NotNull
    private final String nameString;
    @NotNull
    private final List<NameParserRule> rules;

    public NameParserArgument(@NotNull String nameString, @NotNull List<NameParserRule> rules) {
        Preconditions.notNullAndNotEmpty((String)nameString, (String)"nameString");
        if (rules.isEmpty()) {
            throw new IllegalArgumentException("At least one rule is mandatory!");
        }
        this.nameString = nameString;
        this.rules = rules;
    }

    @NotNull
    public String getNameString() {
        return this.nameString;
    }

    @NotNull
    public List<NameParserRule> getRules() {
        return this.rules;
    }
}

