package org.nakedobjects.webserver.viewer;

import org.nakedobjects.runtime.NakedObjects;
import org.nakedobjects.runtime.viewer.NakedObjectsViewer;
import org.nakedobjects.runtime.viewer.NakedObjectsViewerInstallerAbstract;
import org.nakedobjects.runtime.web.WebAppSpecification;

/**
 * Convenience implementation of a {@link NakedObjectsViewer} providing the
 * ability to run a Jetty web server, running whatever is available in the
 * <tt>web.xml</tt> from the {@link NakedObjects command line}.
 * 
 * <p>
 * Intended to be used in projects which have a <tt>war</tt> packaging (that is,
 * <tt>src/main/webapp</tt> directory etc).
 * 
 * <p>
 * To run, use the <tt>--viewer jetty</tt> flag.
 * 
 * <p>
 * In a production deployment the configuration represented by the
 * {@link WebAppSpecification} would be specified in the <tt>web.xml<tt> file.
 */
public class JettyViewerInstaller extends NakedObjectsViewerInstallerAbstract {

	public JettyViewerInstaller() {
		super("jetty");
	}

	@Override
	protected NakedObjectsViewer doCreateViewer() {
		return new JettyViewer();
	}
}
