package org.nakedobjects.webserver.viewer;

import static org.nakedobjects.webserver.WebServerConstants.EMBEDDED_WEB_SERVER_PORT_DEFAULT;
import static org.nakedobjects.webserver.WebServerConstants.EMBEDDED_WEB_SERVER_PORT_KEY;
import static org.nakedobjects.webserver.WebServerConstants.EMBEDDED_WEB_SERVER_RESOURCE_BASE_KEY;
import static org.nakedobjects.webserver.WebServerConstants.EMBEDDED_WEB_SERVER_RESOURCE_BASE_DEFAULT;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.mortbay.jetty.Server;
import org.mortbay.jetty.webapp.WebAppContext;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.metamodel.commons.lang.CastUtils;
import org.nakedobjects.metamodel.config.ConfigurationBuilder;
import org.nakedobjects.metamodel.config.ConfigurationPrimer;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.runtime.options.OptionHandler;
import org.nakedobjects.runtime.system.SystemConstants;
import org.nakedobjects.runtime.viewer.NakedObjectsViewerAbstract;
import org.nakedobjects.webserver.WebServerConstants;

public class JettyViewer extends NakedObjectsViewerAbstract {

	private List<OptionHandler> flagHandlers;

	public JettyViewer() {
		super();
	}
	
	@Override
	public void init() {
		super.init();
		
		NakedObjectConfiguration configuration = getConfigurationBuilder().getConfiguration();
		
		// we don't bootstrap the system here; instead we expect it to be bootstrapped 
		// from the ServletContextInitializer in the web.xml
		int port = configuration.getInteger(EMBEDDED_WEB_SERVER_PORT_KEY, EMBEDDED_WEB_SERVER_PORT_DEFAULT);
		String webappContextPath = configuration.getString(EMBEDDED_WEB_SERVER_RESOURCE_BASE_KEY, EMBEDDED_WEB_SERVER_RESOURCE_BASE_DEFAULT);
		
		Server server = new Server(port);
		WebAppContext context = new WebAppContext("src/main/webapp", webappContextPath);
		
		copyConfigurationPrimersIntoServletContext(context);
		
		server.setHandler(context);
		try {
			server.start();
			server.join(); 
		} catch (Exception ex) {
			throw new NakedObjectException("Unable to start Jetty server", ex);
		}
	}

	@SuppressWarnings("unchecked")
	private void copyConfigurationPrimersIntoServletContext(WebAppContext context) {
		List<ConfigurationPrimer> configurationPrimers = (List<ConfigurationPrimer>)(List<?>)flagHandlers;
		context.setAttribute("nakedobjects.configurationPrimers", 
				configurationPrimers);
	}

	@SuppressWarnings("unused")
	private void copyDeploymentTypeIntoInitParams(WebAppContext context) {
		Map<String,String> initParams = CastUtils.cast(context.getInitParams());
		initParams = new HashMap<String, String>(initParams);
		initParams.put(SystemConstants.DEPLOYMENT_TYPE_KEY, getDeploymentType().name());
		context.setInitParams(initParams);
	}

	public void setFlagHandlers(List<OptionHandler> flagHandlers) {
		this.flagHandlers = flagHandlers;
	}
}
