package org.nakedobjects.webserver;

import java.util.List;

import org.nakedobjects.metamodel.commons.lang.ArrayUtils;
import org.nakedobjects.metamodel.config.ConfigurationBuilder;
import org.nakedobjects.runtime.NakedObjects;
import org.nakedobjects.runtime.installers.InstallerLookup;
import org.nakedobjects.runtime.options.standard.OptionHandlerDeploymentType;
import org.nakedobjects.runtime.system.DeploymentType;
import org.nakedobjects.runtime.viewer.NakedObjectsViewer;
import org.nakedobjects.runtime.viewer.NakedObjectsViewerInstaller;
import org.nakedobjects.webserver.internal.FlagHandlerAddress;
import org.nakedobjects.webserver.internal.FlagHandlerPort;
import org.nakedobjects.webserver.internal.FlagHandlerResourceBase;
import org.nakedobjects.webserver.viewer.JettyViewer;
import org.nakedobjects.webserver.viewer.JettyViewerInstaller;

public class WebServer extends NakedObjects {
	
	public static void main(String[] args) {
		new WebServer().run(ArrayUtils.append(args, "--nosplash","--type",DeploymentType.SERVER.friendlyName()));
	}
	
	@Override
	protected void addOptionHandlers(InstallerLookup installerLookup) {
		super.addOptionHandlers(installerLookup);
		addOptionHandler(new FlagHandlerPort());
		addOptionHandler(new FlagHandlerAddress());
		addOptionHandler(new FlagHandlerResourceBase());
	}
	
	@Override
	protected OptionHandlerDeploymentType createOptionHandlerDeploymentType() {
		return new OptionHandlerDeploymentType(false);
	}

    /**
     * ignores the arguments and just bootstraps JettyViewer, come what may.
     */
	@Override
	protected void bootstrapSystemAndViewers(
			InstallerLookup installerLookup,
			DeploymentType deploymentType, 
			List<String> viewerNames) {
		
		ConfigurationBuilder configurationBuilder = installerLookup.getConfigurationBuilder();
        final NakedObjectsViewerInstaller viewerInstaller = installerLookup.viewerInstaller(JettyViewerInstaller.class.getName(), null);
        JettyViewer viewer = (JettyViewer) viewerInstaller.createViewer();
        
        viewer.setFlagHandlers(getFlagHandlers());
        configurationBuilder.injectInto(viewer);
        installerLookup.injectInto(viewer);
        
        viewer.init();
	}
}
