package org.nakedobjects.metamodel.config.loader;

import junit.framework.TestCase;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.metamodel.config.loader.ConfigurationLoaderDefault;


public class DefaultConfigurationLoaderTest extends TestCase {
    ConfigurationLoaderDefault loader;

    @Override
    protected void setUp() throws Exception {
        Logger.getRootLogger().setLevel(Level.OFF);
        loader = new ConfigurationLoaderDefault("src/test/config");
    }

    public void testDefaultConfiguration() {
        final NakedObjectConfiguration configuration = loader.load();
        assertEquals("one", configuration.getString("properties.example"));
    }

    public void testDefaultConfigurationTrailingWhitespace() {
        final NakedObjectConfiguration configuration = loader.load();
        assertEquals("in-memory", configuration.getString("properties.trailingWhitespace"));
    }

    public void testAddConfiguration() {
        loader.addConfigurationFile("another.properties", NotFoundPolicy.FAIL_FAST);
        final NakedObjectConfiguration configuration = loader.load();
        assertEquals("added", configuration.getString("additional.example"));
    }

    public void testAddedConfigurationOveridesEarlierProperties() {
        loader.addConfigurationFile("another.properties", NotFoundPolicy.FAIL_FAST);
        final NakedObjectConfiguration configuration = loader.load();
        assertEquals("two", configuration.getString("properties.example"));
    }

    public void testAddedConfigurationFailsWhenFileNotFound() {
        try {
            loader.addConfigurationFile("unfound.properties", NotFoundPolicy.FAIL_FAST);
            fail();
        } catch (final NakedObjectException expected) {}
    }

    public void testAddedConfigurationIgnoreUnfoundFile() {
        loader.addConfigurationFile("unfound.properties", NotFoundPolicy.CONTINUE);
    }

    public void testAddProperty() throws Exception {
        loader.add("added.property", "added by code");
        final NakedObjectConfiguration configuration = loader.load();
        assertEquals("added by code", configuration.getString("added.property"));
    }

    public void testIncludeSystemProperty() throws Exception {
        loader.setIncludeSystemProperties(true);
        final NakedObjectConfiguration configuration = loader.load();
        assertEquals(System.getProperty("os.name"), configuration.getString("os.name"));
    }

    public void testAddConfigurationInDifferentDirectory() throws Exception {
        loader.addConfigurationFile("src/test", "three.properties", NotFoundPolicy.FAIL_FAST);
        final NakedObjectConfiguration configuration = loader.load();
        assertEquals("version 3", configuration.getString("different.property"));
    }
}

// Copyright (c) Naked Objects Group Ltd.
