/*
 * Decompiled with CFR 0.152.
 */
package org.mybop.influxbd.resultmapper.converter.basics.time;

import java.time.Instant;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClassifier;
import kotlin.reflect.KType;
import kotlin.reflect.full.KClassifiers;
import org.jetbrains.annotations.NotNull;
import org.mybop.influxbd.resultmapper.converter.TimeConverter;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/mybop/influxbd/resultmapper/converter/basics/time/InstantConverter;", "Lorg/mybop/influxbd/resultmapper/converter/TimeConverter;", "Ljava/time/Instant;", "()V", "convert", "", "instant", "precision", "Ljava/util/concurrent/TimeUnit;", "reverse", "value", "", "supportedType", "Lkotlin/reflect/KType;", "influxdb-resultmapper"})
public final class InstantConverter
implements TimeConverter<Instant> {
    @Override
    @NotNull
    public KType supportedType() {
        return KClassifiers.createType$default((KClassifier)((KClassifier)Reflection.getOrCreateKotlinClass(Instant.class)), null, (boolean)false, null, (int)7, null);
    }

    @Override
    public long convert(@NotNull Instant instant) {
        Intrinsics.checkParameterIsNotNull((Object)instant, (String)"instant");
        return instant.getEpochSecond() * 1000000000L + (long)instant.getNano();
    }

    @Override
    @NotNull
    public TimeUnit precision() {
        return TimeUnit.NANOSECONDS;
    }

    @Override
    @NotNull
    public Instant reverse(@NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Instant instant = Instant.parse(value);
        Intrinsics.checkExpressionValueIsNotNull((Object)instant, (String)"Instant.parse(value)");
        return instant;
    }
}

