/*
 * Decompiled with CFR 0.152.
 */
package org.minidns.dane.java7;

import java.net.Socket;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;
import org.minidns.dane.DaneVerifier;
import org.minidns.dnssec.DnssecClient;

public class DaneExtendedTrustManager
extends X509ExtendedTrustManager {
    private static final Logger LOGGER = Logger.getLogger(DaneExtendedTrustManager.class.getName());
    private final X509TrustManager base;
    private final DaneVerifier verifier;

    public static void inject() {
        DaneExtendedTrustManager.inject(new DaneExtendedTrustManager());
    }

    public static void inject(DaneExtendedTrustManager trustManager) {
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, new TrustManager[]{trustManager}, null);
            SSLContext.setDefault(sslContext);
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public DaneExtendedTrustManager() {
        this(DaneExtendedTrustManager.getDefaultTrustManager());
    }

    public DaneExtendedTrustManager(DnssecClient client) {
        this(client, DaneExtendedTrustManager.getDefaultTrustManager());
    }

    private static X509TrustManager getDefaultTrustManager() {
        try {
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init((KeyStore)null);
            for (TrustManager trustManager : tmf.getTrustManagers()) {
                if (!(trustManager instanceof X509TrustManager)) continue;
                return (X509TrustManager)trustManager;
            }
        }
        catch (KeyStoreException | NoSuchAlgorithmException e) {
            throw new RuntimeException("X.509 not supported.", e);
        }
        return null;
    }

    public DaneExtendedTrustManager(X509TrustManager base) {
        this(new DaneVerifier(), base);
    }

    public DaneExtendedTrustManager(DnssecClient client, X509TrustManager base) {
        this(new DaneVerifier(client), base);
    }

    public DaneExtendedTrustManager(DaneVerifier verifier, X509TrustManager base) {
        this.verifier = verifier;
        this.base = base;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        if (this.base == null) {
            LOGGER.warning("DaneExtendedTrustManager invalidly used for client certificate check and no fallback X509TrustManager specified");
        } else {
            LOGGER.info("DaneExtendedTrustManager invalidly used for client certificate check forwarding request to fallback X509TrustManage");
            if (this.base instanceof X509ExtendedTrustManager) {
                ((X509ExtendedTrustManager)this.base).checkClientTrusted(chain, authType, socket);
            } else {
                this.base.checkClientTrusted(chain, authType);
            }
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        if (!this.verifier.verifyCertificateChain(chain, socket.getInetAddress().getHostName(), socket.getPort())) {
            if (this.base instanceof X509ExtendedTrustManager) {
                ((X509ExtendedTrustManager)this.base).checkServerTrusted(chain, authType, socket);
            } else {
                this.base.checkClientTrusted(chain, authType);
            }
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
        if (this.base == null) {
            LOGGER.warning("DaneExtendedTrustManager invalidly used for client certificate check and no fallback X509TrustManager specified");
        } else {
            LOGGER.info("DaneExtendedTrustManager invalidly used for client certificate check, forwarding request to fallback X509TrustManage");
            if (this.base instanceof X509ExtendedTrustManager) {
                ((X509ExtendedTrustManager)this.base).checkClientTrusted(chain, authType, engine);
            } else {
                this.base.checkClientTrusted(chain, authType);
            }
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
        if (!this.verifier.verifyCertificateChain(chain, engine.getPeerHost(), engine.getPeerPort())) {
            if (this.base instanceof X509ExtendedTrustManager) {
                ((X509ExtendedTrustManager)this.base).checkServerTrusted(chain, authType, engine);
            } else {
                this.base.checkClientTrusted(chain, authType);
            }
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        if (this.base == null) {
            LOGGER.warning("DaneExtendedTrustManager invalidly used for client certificate check and no fallback X509TrustManager specified");
        } else {
            LOGGER.info("DaneExtendedTrustManager invalidly used for client certificate check, forwarding request to fallback X509TrustManage");
            this.base.checkClientTrusted(chain, authType);
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        LOGGER.info("DaneExtendedTrustManager cannot be used without hostname information, forwarding request to fallback X509TrustManage");
        this.base.checkServerTrusted(chain, authType);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.base.getAcceptedIssuers();
    }
}

