/*
 * Decompiled with CFR 0.152.
 */
package org.microprofileext.jaxrs.exceptionhandler;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.Providers;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@Provider
@Produces(value={"application/json", "application/xml", "text/plain"})
public class RuntimeExceptionMapper
implements ExceptionMapper<RuntimeException> {
    private static final Logger log = Logger.getLogger(RuntimeExceptionMapper.class.getName());
    @Inject
    private Config config;
    @Context
    private Providers providers;
    @Inject
    @ConfigProperty(name="jaxrs-ext.includeClassName", defaultValue="false")
    private boolean includeClassName;
    @Inject
    @ConfigProperty(name="jaxrs-ext.includeStacktrace", defaultValue="false")
    private boolean includeStacktrace;
    @Inject
    @ConfigProperty(name="jaxrs-ext.stacktraceLogLevel", defaultValue="FINEST")
    private String stacktraceLogLevel;
    private static final String REASON = "reason";
    private static final String EMPTY = "";
    private static final String OPEN_BRACKET = "[";
    private static final String CLOSE_BRACKET = "]";
    private static final String STATUS_CODE_KEY = "/mp-jaxrs-ext/statuscode";

    public Response toResponse(RuntimeException exception) {
        return this.handleThrowable(exception);
    }

    private Response handleThrowable(Throwable exception) {
        if (exception instanceof WebApplicationException) {
            return ((WebApplicationException)exception).getResponse();
        }
        if (exception != null) {
            String configkey = exception.getClass().getName() + STATUS_CODE_KEY;
            Optional possibleDynamicMapperValue = this.config.getOptionalValue(configkey, Integer.class);
            if (possibleDynamicMapperValue.isPresent()) {
                int status = (Integer)possibleDynamicMapperValue.get();
                if (status < 0) {
                    return this.handleNotMapped(exception);
                }
                String reason = this.getReason(exception);
                log.log(this.getLevel(), reason, exception);
                Response.ResponseBuilder responseBuilder = Response.status((int)status).header(REASON, (Object)reason);
                if (this.includeStacktrace) {
                    responseBuilder = responseBuilder.entity((Object)this.getStacktrace(exception));
                }
                return responseBuilder.build();
            }
            if (exception.getCause() != null && this.providers != null) {
                Throwable cause = exception.getCause();
                return this.handleThrowable(cause);
            }
            return this.handleNotMapped(exception);
        }
        return this.handleNullException();
    }

    private String getReason(Throwable exception) {
        String reason = exception.getMessage();
        if (reason == null || reason.isEmpty()) {
            Throwable cause = exception.getCause();
            if (cause != null) {
                return this.getReason(cause);
            }
            return this.constructReason(exception, "Unknown exception");
        }
        return this.constructReason(exception, reason);
    }

    private String constructReason(Throwable exception, String message) {
        String premessage = EMPTY;
        if (this.includeClassName) {
            premessage = OPEN_BRACKET + exception.getClass().getName() + CLOSE_BRACKET;
        }
        return premessage + message;
    }

    private Response handleNotMapped(Throwable exception) {
        log.log(this.getLevel(), "Unmapped Runtime Exception", exception);
        List<String> reasons = this.getReasons(exception, new ArrayList<String>());
        Response.ResponseBuilder builder = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        for (String reason : reasons) {
            builder = builder.header(REASON, (Object)reason);
        }
        if (this.includeStacktrace) {
            builder = builder.entity((Object)this.getStacktrace(exception));
        }
        return builder.build();
    }

    /*
     * Exception decompiling
     */
    private String getStacktrace(Throwable exception) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Response handleNullException() {
        log.log(this.getLevel(), "Runtime Exception that is null");
        Response.ResponseBuilder builder = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        return builder.build();
    }

    private List<String> getReasons(Throwable exception, List<String> reasons) {
        if (exception.getMessage() != null) {
            reasons.add(exception.getMessage());
        }
        if (exception.getCause() != null) {
            return this.getReasons(exception.getCause(), reasons);
        }
        return reasons;
    }

    private Level getLevel() {
        return Level.parse(this.stacktraceLogLevel);
    }
}

