/*
 * Decompiled with CFR 0.152.
 */
package org.mechdancer.framework.remote;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.Socket;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mechdancer.framework.dependency.Component;
import org.mechdancer.framework.dependency.DynamicScope;
import org.mechdancer.framework.dependency.FunctionsKt;
import org.mechdancer.framework.remote.modules.group.GroupMonitor;
import org.mechdancer.framework.remote.modules.multicast.MulticastBroadcaster;
import org.mechdancer.framework.remote.modules.multicast.MulticastReceiver;
import org.mechdancer.framework.remote.modules.multicast.PacketSlicer;
import org.mechdancer.framework.remote.modules.tcpconnection.PortBroadcaster;
import org.mechdancer.framework.remote.modules.tcpconnection.PortMonitor;
import org.mechdancer.framework.remote.modules.tcpconnection.ShortConnectionClient;
import org.mechdancer.framework.remote.modules.tcpconnection.ShortConnectionServer;
import org.mechdancer.framework.remote.protocol.RemotePacket;
import org.mechdancer.framework.remote.resources.Addresses;
import org.mechdancer.framework.remote.resources.Command;
import org.mechdancer.framework.remote.resources.Group;
import org.mechdancer.framework.remote.resources.MulticastSockets;
import org.mechdancer.framework.remote.resources.Name;
import org.mechdancer.framework.remote.resources.Networks;
import org.mechdancer.framework.remote.resources.ServerSockets;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u00b6\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 @2\u00020\u0001:\u0001@B1\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nJ\u0006\u0010+\u001a\u00020\u0006J\u0011\u0010,\u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u0003H\u0086\u0004J\u0016\u0010-\u001a\u00020\u00062\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201J\u0018\u00102\u001a\u0004\u0018\u0001032\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010.\u001a\u00020/J\u0017\u00104\u001a\b\u0012\u0004\u0012\u00020\u0003052\u0006\u00106\u001a\u000207H\u0086\u0002J\u0013\u00104\u001a\u0004\u0018\u0001082\u0006\u0010\u0002\u001a\u00020\u0003H\u0086\u0002J\u000b\u00109\u001a\u0004\u0018\u00010:H\u0086\u0002J\u0006\u0010;\u001a\u000207J\u0006\u0010<\u001a\u00020=J\r\u0010>\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010?R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020*X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lorg/mechdancer/framework/remote/RemoteHub;", "", "name", "", "newMemberDetected", "Lkotlin/Function1;", "", "additional", "", "Lorg/mechdancer/framework/dependency/Component;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;Ljava/lang/Iterable;)V", "addresses", "Lorg/mechdancer/framework/remote/resources/Addresses;", "broadcaster", "Lorg/mechdancer/framework/remote/modules/multicast/MulticastBroadcaster;", "client", "Lorg/mechdancer/framework/remote/modules/tcpconnection/ShortConnectionClient;", "components", "", "getComponents", "()Ljava/util/Set;", "group", "Lorg/mechdancer/framework/remote/resources/Group;", "monitor", "Lorg/mechdancer/framework/remote/modules/group/GroupMonitor;", "networks", "Lorg/mechdancer/framework/remote/resources/Networks;", "receiver", "Lorg/mechdancer/framework/remote/modules/multicast/MulticastReceiver;", "scope", "Lorg/mechdancer/framework/dependency/DynamicScope;", "server", "Lorg/mechdancer/framework/remote/modules/tcpconnection/ShortConnectionServer;", "servers", "Lorg/mechdancer/framework/remote/resources/ServerSockets;", "slicer", "Lorg/mechdancer/framework/remote/modules/multicast/PacketSlicer;", "sockets", "Lorg/mechdancer/framework/remote/resources/MulticastSockets;", "synchronizer1", "Lorg/mechdancer/framework/remote/modules/tcpconnection/PortBroadcaster;", "synchronizer2", "Lorg/mechdancer/framework/remote/modules/tcpconnection/PortMonitor;", "accept", "ask", "broadcast", "cmd", "Lorg/mechdancer/framework/remote/resources/Command;", "payload", "", "connect", "Ljava/net/Socket;", "get", "", "timeout", "", "Ljava/net/InetSocketAddress;", "invoke", "Lorg/mechdancer/framework/remote/protocol/RemotePacket;", "openAllNetworks", "openOneNetwork", "", "yell", "()Lkotlin/Unit;", "Companion", "remote"})
public final class RemoteHub {
    private final Group group;
    private final GroupMonitor monitor;
    private final Networks networks;
    private final MulticastSockets sockets;
    private final MulticastBroadcaster broadcaster;
    private final MulticastReceiver receiver;
    private final PacketSlicer slicer;
    private final Addresses addresses;
    private final ServerSockets servers;
    private final PortBroadcaster synchronizer1;
    private final PortMonitor synchronizer2;
    private final ShortConnectionClient client;
    private final ShortConnectionServer server;
    private final DynamicScope scope;
    @NotNull
    private static final InetSocketAddress ADDRESS;
    @Deprecated
    public static final Companion Companion;

    @NotNull
    public final Set<Component> getComponents() {
        return this.scope.getComponents();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean openOneNetwork() {
        Map<NetworkInterface, MulticastSocket> map = this.sockets.getView();
        if (!map.isEmpty()) {
            return true;
        }
        boolean bl = false;
        if (bl) return true;
        NetworkInterface networkInterface = (NetworkInterface)CollectionsKt.firstOrNull((Iterable)this.networks.getView().keySet());
        if (networkInterface == null) return false;
        Map<NetworkInterface, MulticastSocket> it = map = networkInterface;
        this.sockets.get((NetworkInterface)((Object)it));
        Map<NetworkInterface, MulticastSocket> map2 = map;
        if (map2 == null) return false;
        return true;
    }

    public final int openAllNetworks() {
        for (NetworkInterface network : this.networks.getView().keySet()) {
            this.sockets.get(network);
        }
        return this.sockets.getView().size();
    }

    @NotNull
    public final List<String> get(int timeout) {
        return this.group.get(timeout);
    }

    @Nullable
    public final InetSocketAddress get(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return this.addresses.get(name);
    }

    @Nullable
    public final Unit yell() {
        return this.monitor.yell();
    }

    public final void ask(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        this.synchronizer2.ask(name);
    }

    public final void broadcast(@NotNull Command cmd, @NotNull byte[] payload) {
        Intrinsics.checkParameterIsNotNull((Object)cmd, (String)"cmd");
        Intrinsics.checkParameterIsNotNull((Object)payload, (String)"payload");
        this.broadcaster.broadcast(cmd, payload);
    }

    @Nullable
    public final Socket connect(@NotNull String name, @NotNull Command cmd) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)cmd, (String)"cmd");
        return this.client.connect(name, cmd);
    }

    @Nullable
    public final RemotePacket invoke() {
        return this.receiver.invoke();
    }

    public final void accept() {
        ShortConnectionServer.invoke$default(this.server, 0, 1, null);
    }

    public RemoteHub(@Nullable String name, @NotNull Function1<? super String, Unit> newMemberDetected2, @NotNull Iterable<? extends Component> additional) {
        Intrinsics.checkParameterIsNotNull(newMemberDetected2, (String)"newMemberDetected");
        Intrinsics.checkParameterIsNotNull(additional, (String)"additional");
        this.group = new Group();
        this.monitor = new GroupMonitor(newMemberDetected2);
        this.networks = new Networks();
        this.sockets = new MulticastSockets(ADDRESS);
        this.broadcaster = new MulticastBroadcaster();
        this.receiver = new MulticastReceiver(0, 1, null);
        this.slicer = new PacketSlicer(0, 1, null);
        this.addresses = new Addresses();
        this.servers = new ServerSockets(0, 1, null);
        this.synchronizer1 = new PortBroadcaster();
        this.synchronizer2 = new PortMonitor();
        this.client = new ShortConnectionClient();
        this.server = new ShortConnectionServer();
        this.scope = FunctionsKt.scope((Function1<? super DynamicScope, Unit>)((Function1)new Function1<DynamicScope, Unit>(this, name, additional){
            final /* synthetic */ RemoteHub this$0;
            final /* synthetic */ String $name;
            final /* synthetic */ Iterable $additional;

            public final void invoke(@NotNull DynamicScope $receiver) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                String string = this.$name;
                if (string == null) {
                    string = RemoteHub.access$Companion().getRandomName();
                }
                FunctionsKt.plusAssign($receiver, new Name(string));
                FunctionsKt.plusAssign($receiver, RemoteHub.access$getGroup$p(this.this$0));
                FunctionsKt.plusAssign($receiver, RemoteHub.access$getMonitor$p(this.this$0));
                FunctionsKt.plusAssign($receiver, RemoteHub.access$getNetworks$p(this.this$0));
                FunctionsKt.plusAssign($receiver, RemoteHub.access$getSockets$p(this.this$0));
                FunctionsKt.plusAssign($receiver, RemoteHub.access$getBroadcaster$p(this.this$0));
                FunctionsKt.plusAssign($receiver, RemoteHub.access$getReceiver$p(this.this$0));
                FunctionsKt.plusAssign($receiver, RemoteHub.access$getSlicer$p(this.this$0));
                FunctionsKt.plusAssign($receiver, RemoteHub.access$getAddresses$p(this.this$0));
                FunctionsKt.plusAssign($receiver, RemoteHub.access$getServers$p(this.this$0));
                FunctionsKt.plusAssign($receiver, RemoteHub.access$getSynchronizer1$p(this.this$0));
                FunctionsKt.plusAssign($receiver, RemoteHub.access$getSynchronizer2$p(this.this$0));
                FunctionsKt.plusAssign($receiver, RemoteHub.access$getServer$p(this.this$0));
                FunctionsKt.plusAssign($receiver, RemoteHub.access$getClient$p(this.this$0));
                for (Component dependency : this.$additional) {
                    FunctionsKt.plusAssign($receiver, dependency);
                }
            }
            {
                this.this$0 = remoteHub2;
                this.$name = string;
                this.$additional = iterable;
                super(1);
            }
        }));
    }

    static {
        Companion = new Companion(null);
        ADDRESS = new InetSocketAddress(InetAddress.getByName("233.33.33.33"), 23333);
    }

    @NotNull
    public static final /* synthetic */ Group access$getGroup$p(RemoteHub $this) {
        return $this.group;
    }

    @NotNull
    public static final /* synthetic */ GroupMonitor access$getMonitor$p(RemoteHub $this) {
        return $this.monitor;
    }

    @NotNull
    public static final /* synthetic */ Networks access$getNetworks$p(RemoteHub $this) {
        return $this.networks;
    }

    @NotNull
    public static final /* synthetic */ MulticastSockets access$getSockets$p(RemoteHub $this) {
        return $this.sockets;
    }

    @NotNull
    public static final /* synthetic */ MulticastBroadcaster access$getBroadcaster$p(RemoteHub $this) {
        return $this.broadcaster;
    }

    @NotNull
    public static final /* synthetic */ MulticastReceiver access$getReceiver$p(RemoteHub $this) {
        return $this.receiver;
    }

    @NotNull
    public static final /* synthetic */ PacketSlicer access$getSlicer$p(RemoteHub $this) {
        return $this.slicer;
    }

    @NotNull
    public static final /* synthetic */ Addresses access$getAddresses$p(RemoteHub $this) {
        return $this.addresses;
    }

    @NotNull
    public static final /* synthetic */ ServerSockets access$getServers$p(RemoteHub $this) {
        return $this.servers;
    }

    @NotNull
    public static final /* synthetic */ PortBroadcaster access$getSynchronizer1$p(RemoteHub $this) {
        return $this.synchronizer1;
    }

    @NotNull
    public static final /* synthetic */ PortMonitor access$getSynchronizer2$p(RemoteHub $this) {
        return $this.synchronizer2;
    }

    @NotNull
    public static final /* synthetic */ ShortConnectionServer access$getServer$p(RemoteHub $this) {
        return $this.server;
    }

    @NotNull
    public static final /* synthetic */ ShortConnectionClient access$getClient$p(RemoteHub $this) {
        return $this.client;
    }

    @NotNull
    public static final /* synthetic */ Companion access$Companion() {
        return Companion;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/mechdancer/framework/remote/RemoteHub$Companion;", "", "()V", "ADDRESS", "Ljava/net/InetSocketAddress;", "getADDRESS", "()Ljava/net/InetSocketAddress;", "randomName", "", "getRandomName", "()Ljava/lang/String;", "remote"})
    private static final class Companion {
        @NotNull
        public final InetSocketAddress getADDRESS() {
            return ADDRESS;
        }

        @NotNull
        public final String getRandomName() {
            return "RemoteHub[" + UUID.randomUUID() + ']';
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

