/*
 * Decompiled with CFR 0.152.
 */
package org.mechdancer.remote.plugins;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mechdancer.remote.core.RemoteHub;
import org.mechdancer.remote.core.RemotePlugin;
import org.mechdancer.remote.core.internal.Command;
import org.mechdancer.remote.core.protocol.PreLengthStreamKt;
import org.mechdancer.remote.plugins.ResourcePlugin;
import org.mechdancer.remote.plugins.ResourcePlugin$WhenMappings;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u00002\u00020\u0001:\u000201B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012*\u0010\u0004\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00060\u0005\"\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\bH\u0002J\u0010\u0010!\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u0007H\u0002J\u0010\u0010\"\u001a\u00020#2\u0006\u0010\u001f\u001a\u00020\u0007H\u0002J\u001c\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00062\u0006\u0010 \u001a\u00020\bH\u0002J\u001e\u0010%\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010&\u0012\u0004\u0012\u00020\b0\u00062\u0006\u0010'\u001a\u00020\bH\u0002J \u0010(\u001a\n \u001d*\u0004\u0018\u00010\b0\b2\u0006\u0010\u001f\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\bH\u0002J\u0013\u0010)\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001f\u001a\u00020\u0007H\u0086\u0002J\u0018\u0010*\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001f\u001a\u00020\u00072\u0006\u0010+\u001a\u00020\u0003J\u0018\u0010,\u001a\u00020\u00122\u0006\u0010-\u001a\u00020\u00072\u0006\u0010'\u001a\u00020\bH\u0016J\u0010\u0010.\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010/\u001a\u00020\u0012H\u0016R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00030\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000R \u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R \u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00120\u0011X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0014R\u0012\u0010\u0017\u001a\u00060\u0018R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00070\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001b\u001a\n \u001d*\u0004\u0018\u00010\u001c0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lorg/mechdancer/remote/plugins/ResourcePlugin;", "Lorg/mechdancer/remote/core/RemotePlugin;", "retryPeriod", "", "resources", "", "Lkotlin/Pair;", "", "", "(J[Lkotlin/Pair;)V", "asked", "Ljava/util/concurrent/ConcurrentSkipListMap;", "askedTimes", "", "host", "Lorg/mechdancer/remote/core/RemoteHub;", "onResourceAck", "Lkotlin/Function1;", "", "getOnResourceAck$remote", "()Lkotlin/jvm/functions/Function1;", "onResourceAsk", "getOnResourceAsk$remote", "resource", "Lorg/mechdancer/remote/plugins/ResourcePlugin$RemoteResource;", "resourceToAsk", "Ljava/util/concurrent/LinkedTransferQueue;", "worker", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "ack", "resourceId", "data", "ask", "askResource", "", "decodeAck", "decodePayload", "Lorg/mechdancer/remote/plugins/ResourcePlugin$Cmd;", "payload", "encodeAck", "get", "getResource", "timeout", "onBroadcast", "sender", "onSetup", "onTeardown", "Cmd", "RemoteResource", "remote"})
public final class ResourcePlugin
extends RemotePlugin {
    private final ExecutorService worker;
    private final RemoteResource resource;
    private RemoteHub host;
    private final LinkedTransferQueue<String> resourceToAsk;
    private final ConcurrentSkipListMap<String, Long> asked;
    private final ConcurrentSkipListMap<String, Integer> askedTimes;
    @NotNull
    private final Function1<String, Unit> onResourceAsk;
    @NotNull
    private final Function1<byte[], Unit> onResourceAck;
    private final long retryPeriod;

    @Override
    public void onSetup(@NotNull RemoteHub host) {
        Intrinsics.checkParameterIsNotNull((Object)host, (String)"host");
        this.host = host;
        this.worker.submit(new Runnable(this){
            final /* synthetic */ ResourcePlugin this$0;

            public final void run() {
                while (true) {
                    E e = ResourcePlugin.access$getResourceToAsk$p(this.this$0).take();
                    Intrinsics.checkExpressionValueIsNotNull(e, (String)"resourceToAsk.take()");
                    ResourcePlugin.access$ask(this.this$0, (String)e);
                }
            }
            {
                this.this$0 = resourcePlugin;
            }
        });
        this.worker.submit(new Runnable(this){
            final /* synthetic */ ResourcePlugin this$0;

            public final void run() {
                while (true) {
                    ResourcePlugin.access$getAsked$p(this.this$0).forEach((BiConsumer)new BiConsumer<String, Long>(this){
                        final /* synthetic */ onSetup.2 this$0;

                        public final void accept(@NotNull String id, @NotNull Long stamp) {
                            Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
                            Intrinsics.checkParameterIsNotNull((Object)stamp, (String)"stamp");
                            if (System.currentTimeMillis() - stamp > ResourcePlugin.access$getRetryPeriod$p(this.this$0.this$0)) {
                                ResourcePlugin.access$ask(this.this$0.this$0, id);
                            }
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    });
                }
            }
            {
                this.this$0 = resourcePlugin;
            }
        });
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void onBroadcast(@NotNull String sender, @NotNull byte[] payload) {
        void cmd;
        Intrinsics.checkParameterIsNotNull((Object)sender, (String)"sender");
        Intrinsics.checkParameterIsNotNull((Object)payload, (String)"payload");
        Pair<Cmd, byte[]> pair = this.decodePayload(payload);
        Cmd cmd2 = (Cmd)pair.component1();
        byte[] data = (byte[])pair.component2();
        void v0 = cmd;
        if (v0 == null) throw (Throwable)new IllegalArgumentException();
        switch (ResourcePlugin$WhenMappings.$EnumSwitchMapping$0[v0.ordinal()]) {
            case 1: {
                Function1<String, Unit> function1 = this.onResourceAsk;
                String string = new String(data, Charsets.UTF_8);
                function1.invoke((Object)string);
                return;
            }
            case 2: {
                this.onResourceAck.invoke((Object)data);
                return;
            }
            default: {
                return;
            }
        }
    }

    @Override
    public void onTeardown() {
        this.worker.shutdown();
    }

    @Nullable
    public final byte[] get(@NotNull String resourceId) {
        Intrinsics.checkParameterIsNotNull((Object)resourceId, (String)"resourceId");
        return this.getResource(resourceId, 10000L);
    }

    @Nullable
    public final byte[] getResource(@NotNull String resourceId, long timeout) {
        Intrinsics.checkParameterIsNotNull((Object)resourceId, (String)"resourceId");
        return this.resource.get(resourceId, timeout);
    }

    private final void ask(String resourceId) {
        int n;
        RemoteHub remoteHub2 = this.host;
        if (remoteHub2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"host");
        }
        Object object = resourceId;
        Cmd cmd = Cmd.ResourceAsk;
        char c = this.getId();
        RemoteHub remoteHub3 = remoteHub2;
        Comparable<Charset> comparable = Charsets.UTF_8;
        String string = object;
        if (string == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string.getBytes((Charset)comparable);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = byArray;
        remoteHub3.broadcast(c, cmd.join(byArray2));
        object = this.asked;
        comparable = System.currentTimeMillis();
        object.put(resourceId, comparable);
        object = this.askedTimes;
        Integer n2 = this.askedTimes.get(resourceId);
        if (n2 != null) {
            comparable = n2;
            Comparable<Charset> it = comparable;
            n = (Integer)it + 1;
        } else {
            n = 1;
        }
        comparable = n;
        object.put(resourceId, comparable);
    }

    private final void ack(String resourceId, byte[] data) {
        RemoteHub remoteHub2 = this.host;
        if (remoteHub2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"host");
        }
        char c = this.getId();
        byte[] byArray = this.encodeAck(resourceId, data);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"encodeAck(resourceId, data)");
        remoteHub2.broadcast(c, Cmd.ResourceAck.join(byArray));
    }

    private final boolean askResource(String resourceId) {
        return this.resourceToAsk.add(resourceId);
    }

    @NotNull
    public final Function1<String, Unit> getOnResourceAsk$remote() {
        return this.onResourceAsk;
    }

    @NotNull
    public final Function1<byte[], Unit> getOnResourceAck$remote() {
        return this.onResourceAck;
    }

    private final Pair<Cmd, byte[]> decodePayload(byte[] payload) {
        byte[] byArray = payload;
        int n = 1;
        int n2 = payload.length;
        Cmd cmd = Cmd.Companion.get(payload[0]);
        byte[] byArray2 = ArraysKt.copyOfRange((byte[])byArray, (int)n, (int)n2);
        return TuplesKt.to((Object)cmd, (Object)byArray2);
    }

    private final byte[] encodeAck(String resourceId, byte[] data) {
        ByteArrayOutputStream byteArrayOutputStream;
        ByteArrayOutputStream $receiver = byteArrayOutputStream = new ByteArrayOutputStream();
        String string = resourceId;
        OutputStream outputStream = $receiver;
        Charset charset = Charsets.UTF_8;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = byArray;
        PreLengthStreamKt.writeWithLength(outputStream, byArray2);
        $receiver.write(data);
        return byteArrayOutputStream.toByteArray();
    }

    private final Pair<String, byte[]> decodeAck(byte[] data) {
        ByteArrayInputStream byteArrayInputStream;
        ByteArrayInputStream $receiver = byteArrayInputStream = new ByteArrayInputStream(data);
        byte[] byArray = PreLengthStreamKt.readWithLength($receiver);
        return TuplesKt.to((Object)new String(byArray, Charsets.UTF_8), (Object)ByteStreamsKt.readBytes((InputStream)$receiver));
    }

    public ResourcePlugin(long retryPeriod, Pair<String, byte[]> ... resources) {
        Intrinsics.checkParameterIsNotNull(resources, (String)"resources");
        super('R');
        this.retryPeriod = retryPeriod;
        this.worker = Executors.newFixedThreadPool(3);
        this.resource = new RemoteResource(resources);
        this.resourceToAsk = new LinkedTransferQueue();
        this.asked = new ConcurrentSkipListMap();
        this.askedTimes = new ConcurrentSkipListMap();
        this.onResourceAsk = (Function1)new Function1<String, Unit>(this){
            final /* synthetic */ ResourcePlugin this$0;

            public final void invoke(@NotNull String resourceId) {
                Intrinsics.checkParameterIsNotNull((Object)resourceId, (String)"resourceId");
                if (ResourcePlugin.access$getResource$p(this.this$0).getMemory$remote().containsKey(resourceId)) {
                    byte[] byArray = ResourcePlugin.access$getResource$p(this.this$0).getMemory$remote().get(resourceId);
                    if (byArray == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"resource.memory[resourceId]!!");
                    ResourcePlugin.access$ack(this.this$0, resourceId, byArray);
                }
            }
            {
                this.this$0 = resourcePlugin;
                super(1);
            }
        };
        this.onResourceAck = (Function1)new Function1<byte[], Unit>(this){
            final /* synthetic */ ResourcePlugin this$0;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull byte[] payload) {
                void resourceId;
                Intrinsics.checkParameterIsNotNull((Object)payload, (String)"payload");
                Object object = ResourcePlugin.access$decodeAck(this.this$0, payload);
                String string = (String)object.component1();
                byte[] data = (byte[])object.component2();
                if (ResourcePlugin.access$getResource$p(this.this$0).getQueue$remote().contains(resourceId)) {
                    object = ResourcePlugin.access$getResource$p(this.this$0).getMemory$remote();
                    byte[] byArray = data;
                    object.put(resourceId, byArray);
                    ResourcePlugin.access$getResource$p(this.this$0).getQueue$remote().remove(resourceId);
                    ResourcePlugin.access$getAsked$p(this.this$0).remove(resourceId);
                    ResourcePlugin.access$getAskedTimes$p(this.this$0).remove(resourceId);
                }
            }
            {
                this.this$0 = resourcePlugin;
                super(1);
            }
        };
    }

    public static final /* synthetic */ void access$ask(ResourcePlugin $this, @NotNull String resourceId) {
        $this.ask(resourceId);
    }

    @NotNull
    public static final /* synthetic */ LinkedTransferQueue access$getResourceToAsk$p(ResourcePlugin $this) {
        return $this.resourceToAsk;
    }

    public static final /* synthetic */ long access$getRetryPeriod$p(ResourcePlugin $this) {
        return $this.retryPeriod;
    }

    @NotNull
    public static final /* synthetic */ RemoteResource access$getResource$p(ResourcePlugin $this) {
        return $this.resource;
    }

    public static final /* synthetic */ void access$ack(ResourcePlugin $this, @NotNull String resourceId, @NotNull byte[] data) {
        $this.ack(resourceId, data);
    }

    @NotNull
    public static final /* synthetic */ Pair access$decodeAck(ResourcePlugin $this, @NotNull byte[] data) {
        return $this.decodeAck(data);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0002\b\u0080\u0004\u0018\u00002\u00020\u0001:\u0001\u0014B!\u0012\u001a\u0010\u0002\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00040\u0003\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\u0010\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0013R \u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\rX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0015"}, d2={"Lorg/mechdancer/remote/plugins/ResourcePlugin$RemoteResource;", "", "resources", "", "Lkotlin/Pair;", "", "", "(Lorg/mechdancer/remote/plugins/ResourcePlugin;[Lkotlin/Pair;)V", "memory", "Ljava/util/concurrent/ConcurrentHashMap;", "getMemory$remote", "()Ljava/util/concurrent/ConcurrentHashMap;", "queue", "Ljava/util/concurrent/ConcurrentSkipListSet;", "getQueue$remote", "()Ljava/util/concurrent/ConcurrentSkipListSet;", "get", "resourceId", "timeout", "", "RequestTask", "remote"})
    public final class RemoteResource {
        @NotNull
        private final ConcurrentHashMap<String, byte[]> memory;
        @NotNull
        private final ConcurrentSkipListSet<String> queue;

        @NotNull
        public final ConcurrentHashMap<String, byte[]> getMemory$remote() {
            return this.memory;
        }

        @NotNull
        public final ConcurrentSkipListSet<String> getQueue$remote() {
            return this.queue;
        }

        @Nullable
        public final byte[] get(@NotNull String resourceId, long timeout) {
            Intrinsics.checkParameterIsNotNull((Object)resourceId, (String)"resourceId");
            byte[] byArray = this.memory.get(resourceId);
            if (byArray != null) {
                byte[] byArray2;
                byte[] it = byArray2 = byArray;
                return it;
            }
            this.queue.add(resourceId);
            ResourcePlugin.this.askResource(resourceId);
            long start = System.currentTimeMillis();
            while (this.queue.contains(resourceId)) {
                if (System.currentTimeMillis() - start <= timeout) continue;
                ResourcePlugin.this.asked.remove(resourceId);
                ResourcePlugin.this.askedTimes.remove(resourceId);
                this.queue.remove(resourceId);
                return null;
            }
            byte[] byArray3 = this.memory.get(resourceId);
            if (byArray3 == null) {
                Intrinsics.throwNpe();
            }
            return byArray3;
        }

        public RemoteResource(Pair<String, byte[]>[] resources) {
            Intrinsics.checkParameterIsNotNull(resources, (String)"resources");
            this.memory = new ConcurrentHashMap(MapsKt.toMap(resources));
            this.queue = new ConcurrentSkipListSet();
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0011\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0001H\u0096\u0002J\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/mechdancer/remote/plugins/ResourcePlugin$RemoteResource$RequestTask;", "Ljava/util/concurrent/Delayed;", "resourceId", "", "timeOutMilliseconds", "", "(Lorg/mechdancer/remote/plugins/ResourcePlugin$RemoteResource;Ljava/lang/String;J)V", "getResourceId", "()Ljava/lang/String;", "time", "compareTo", "", "other", "getDelay", "unit", "Ljava/util/concurrent/TimeUnit;", "remote"})
        public final class RequestTask
        implements Delayed {
            private final long time;
            @NotNull
            private final String resourceId;

            @Override
            public int compareTo(@NotNull Delayed other) {
                Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
                return (int)(this.getDelay(TimeUnit.MILLISECONDS) - other.getDelay(TimeUnit.MILLISECONDS));
            }

            @Override
            public long getDelay(@NotNull TimeUnit unit) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)unit), (String)"unit");
                return unit.convert(this.time - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
            }

            @NotNull
            public final String getResourceId() {
                return this.resourceId;
            }

            public RequestTask(String resourceId, long timeOutMilliseconds) {
                Intrinsics.checkParameterIsNotNull((Object)resourceId, (String)"resourceId");
                this.resourceId = resourceId;
                this.time = timeOutMilliseconds + System.currentTimeMillis();
            }
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0005\b\u0082\u0001\u0018\u0000 \r2\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002:\u0001\rB\u000f\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0011\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0086\u0004R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\u000bj\u0002\b\f\u00a8\u0006\u000e"}, d2={"Lorg/mechdancer/remote/plugins/ResourcePlugin$Cmd;", "", "Lorg/mechdancer/remote/core/internal/Command;", "id", "", "(Ljava/lang/String;IB)V", "getId", "()B", "join", "", "payload", "ResourceAsk", "ResourceAck", "Companion", "remote"})
    private static final class Cmd
    extends Enum<Cmd>
    implements Command {
        public static final /* enum */ Cmd ResourceAsk;
        public static final /* enum */ Cmd ResourceAck;
        private static final /* synthetic */ Cmd[] $VALUES;
        private final byte id;
        private static final Command.CommandMemory<Cmd> memory;
        public static final Companion Companion;

        static {
            Cmd[] cmdArray = new Cmd[2];
            Cmd[] cmdArray2 = cmdArray;
            cmdArray[0] = ResourceAsk = new Cmd(10);
            cmdArray[1] = ResourceAck = new Cmd(11);
            $VALUES = cmdArray;
            Companion = new Companion(null);
            memory = new Command.CommandMemory((Command[])Cmd.values());
        }

        @NotNull
        public final byte[] join(@NotNull byte[] payload) {
            byte[] byArray;
            Intrinsics.checkParameterIsNotNull((Object)payload, (String)"payload");
            byte[] $receiver = byArray = new byte[payload.length + 1];
            $receiver[0] = this.getId();
            ArraysKt.copyInto$default((byte[])payload, (byte[])$receiver, (int)1, (int)0, (int)0, (int)12, null);
            return byArray;
        }

        @Override
        public byte getId() {
            return this.id;
        }

        protected Cmd(byte id) {
            this.id = id;
        }

        public static Cmd[] values() {
            return (Cmd[])$VALUES.clone();
        }

        public static Cmd valueOf(String string) {
            return Enum.valueOf(Cmd.class, string);
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0086\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/mechdancer/remote/plugins/ResourcePlugin$Cmd$Companion;", "", "()V", "memory", "Lorg/mechdancer/remote/core/internal/Command$CommandMemory;", "Lorg/mechdancer/remote/plugins/ResourcePlugin$Cmd;", "get", "id", "", "remote"})
        public static final class Companion {
            @Nullable
            public final Cmd get(byte id) {
                return (Cmd)memory.get(id);
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

