/*
 * Decompiled with CFR 0.152.
 */
package org.mechdancer.remote.network;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.mechdancer.remote.network.FeatureFiltersKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\"\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\n\u0010\n\u001a\u00020\u0004*\u00020\u0003\u001a\n\u0010\u000b\u001a\u00020\u0004*\u00020\u0003\u001a\n\u0010\f\u001a\u00020\u0004*\u00020\r\u001a)\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002*\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u0002`\u0005H\u0086\u0002\u001a\n\u0010\u000f\u001a\u00020\u0004*\u00020\u0003\u001a\n\u0010\u0010\u001a\u00020\u0004*\u00020\u0003\"'\u0010\u0000\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u0002`\u00050\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"'\u0010\b\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u0002`\u00050\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u0011"}, d2={"MULTICAST_FILTERS", "", "Lkotlin/Function1;", "Ljava/net/NetworkInterface;", "", "Lorg/mechdancer/remote/network/NetFilter;", "getMULTICAST_FILTERS", "()Ljava/util/List;", "WIRELESS_FIRST", "getWIRELESS_FIRST", "containsV4Host", "ethernet", "isV4Host", "Ljava/net/InetAddress;", "not", "virtual", "wireless", "remote"})
public final class FeatureFiltersKt {
    @NotNull
    private static final List<Function1<NetworkInterface, Boolean>> MULTICAST_FILTERS = CollectionsKt.listOf((Object[])new Function1[]{FeatureFiltersKt.not((Function1<? super NetworkInterface, Boolean>)((Function1)MULTICAST_FILTERS.1.INSTANCE)), MULTICAST_FILTERS.2.INSTANCE, MULTICAST_FILTERS.3.INSTANCE, FeatureFiltersKt.not((Function1<? super NetworkInterface, Boolean>)((Function1)MULTICAST_FILTERS.4.INSTANCE))});
    @NotNull
    private static final List<Function1<NetworkInterface, Boolean>> WIRELESS_FIRST = CollectionsKt.listOf((Object[])new Function1[]{WIRELESS_FIRST.1.INSTANCE, WIRELESS_FIRST.2.INSTANCE, FeatureFiltersKt.not((Function1<? super NetworkInterface, Boolean>)((Function1)WIRELESS_FIRST.3.INSTANCE))});

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isV4Host(@NotNull InetAddress $receiver) {
        int it;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        InetAddress inetAddress = $receiver;
        if (!(inetAddress instanceof Inet4Address)) {
            inetAddress = null;
        }
        Inet4Address inet4Address = (Inet4Address)inetAddress;
        Object object = inet4Address;
        if (inet4Address == null) return false;
        byte[] byArray = ((Inet4Address)object).getAddress();
        object = byArray;
        if (byArray == null) return false;
        int n = ArraysKt.first((byte[])object);
        Integer n2 = it + ((it = n) >= 0 ? 0 : 256);
        int n3 = it = ((Number)n2).intValue();
        if (1 > n3) {
            return false;
        }
        if (223 < n3) return false;
        boolean bl = true;
        if (!bl) return false;
        Integer n4 = n2;
        if (n4 == null) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean wireless(@NotNull NetworkInterface $receiver) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        String string2 = $receiver.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"name");
        String string3 = string = string2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
        if (StringsKt.startsWith$default((String)string4, (String)"wlan", (boolean)false, (int)2, null)) return true;
        String string5 = $receiver.getDisplayName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"displayName");
        String string6 = string = string5;
        if (string6 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string7 = string6.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"(this as java.lang.String).toLowerCase()");
        if (!StringsKt.contains$default((CharSequence)string7, (CharSequence)"wireless", (boolean)false, (int)2, null)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean ethernet(@NotNull NetworkInterface $receiver) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        String string2 = $receiver.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"name");
        String string3 = string = string2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
        if (StringsKt.startsWith$default((String)string4, (String)"eth", (boolean)false, (int)2, null)) return true;
        String string5 = $receiver.getDisplayName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"displayName");
        String string6 = string = string5;
        if (string6 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string7 = string6.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"(this as java.lang.String).toLowerCase()");
        string = string7;
        CharSequence charSequence = "ethernet";
        String string8 = string;
        if (string8 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        if (!string8.contentEquals(charSequence)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean virtual(@NotNull NetworkInterface $receiver) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        if ($receiver.isVirtual()) return true;
        String string2 = $receiver.getDisplayName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"displayName");
        String string3 = string = string2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
        if (!StringsKt.contains$default((CharSequence)string4, (CharSequence)"virtual", (boolean)false, (int)2, null)) return false;
        return true;
    }

    public static final boolean containsV4Host(@NotNull NetworkInterface $receiver) {
        boolean bl;
        block3: {
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
            Enumeration<InetAddress> enumeration = $receiver.getInetAddresses();
            Intrinsics.checkExpressionValueIsNotNull(enumeration, (String)"inetAddresses");
            Enumeration<InetAddress> enumeration2 = enumeration;
            ArrayList<InetAddress> arrayList = Collections.list(enumeration2);
            Intrinsics.checkExpressionValueIsNotNull(arrayList, (String)"java.util.Collections.list(this)");
            Iterable $receiver$iv = arrayList;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    InetAddress p1 = (InetAddress)element$iv;
                    if (!FeatureFiltersKt.isV4Host(p1)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public static final Function1<NetworkInterface, Boolean> not(@NotNull Function1<? super NetworkInterface, Boolean> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"receiver$0");
        return (Function1)new Function1<NetworkInterface, Boolean>($receiver){
            final /* synthetic */ Function1 $this_not;

            public final boolean invoke(@NotNull NetworkInterface net) {
                Intrinsics.checkParameterIsNotNull((Object)net, (String)"net");
                return (Boolean)this.$this_not.invoke((Object)net) == false;
            }
            {
                this.$this_not = function1;
                super(1);
            }
        };
    }

    @NotNull
    public static final List<Function1<NetworkInterface, Boolean>> getMULTICAST_FILTERS() {
        return MULTICAST_FILTERS;
    }

    @NotNull
    public static final List<Function1<NetworkInterface, Boolean>> getWIRELESS_FIRST() {
        return WIRELESS_FIRST;
    }
}

