/*
 * Decompiled with CFR 0.152.
 */
package org.mechdancer.dataflow.core.internal;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.mechdancer.common.extension.BooleanKt;
import org.mechdancer.common.extension.Optional;
import org.mechdancer.dataflow.core.intefaces.IEgress;
import org.mechdancer.dataflow.core.internal.UtilityKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\t\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u0012\u001a\u00020\u0013J\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\t\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0015J\u001f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\t2\u0006\u0010\u0016\u001a\u00020\bH\u0096\u0004\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0017J\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\t\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0015J\u001f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\t2\u0006\u0010\u0016\u001a\u00020\bH\u0086\u0002\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0017J\u0013\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001bR#\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\t0\u0007X\u0082\u0004\u00f8\u0001\u0000\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001c"}, d2={"Lorg/mechdancer/dataflow/core/internal/SourceCore;", "T", "Lorg/mechdancer/dataflow/core/intefaces/IEgress;", "size", "", "(I)V", "buffer", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lorg/mechdancer/common/extension/Optional;", "bufferSize", "getBufferSize", "()J", "lastId", "Ljava/util/concurrent/atomic/AtomicLong;", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "removeCount", "clear", "", "consume", "()Ljava/lang/Object;", "id", "(J)Ljava/lang/Object;", "get", "offer", "msg", "(Ljava/lang/Object;)J", "dataflow-jvm"})
public final class SourceCore<T>
implements IEgress<T> {
    private final AtomicLong lastId;
    private final ConcurrentHashMap<Long, Optional<T>> buffer;
    private final AtomicLong removeCount;
    private final ReentrantLock lock;
    private final int size;

    public final long getBufferSize() {
        return this.lastId.get() - this.removeCount.get();
    }

    public final long offer(T msg) {
        long newId = this.lastId.getAndIncrement();
        ((Map)this.buffer).put(newId, Optional.box-impl((Object)BooleanKt.toOptional(msg)));
        UtilityKt.withTryLock(this.lock, (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ SourceCore this$0;

            public final void invoke() {
                while (this.this$0.getBufferSize() > (long)SourceCore.access$getSize$p(this.this$0)) {
                    ConcurrentHashMap.KeySetView keySetView = (ConcurrentHashMap.KeySetView)SourceCore.access$getBuffer$p(this.this$0).keySet();
                    Intrinsics.checkExpressionValueIsNotNull((Object)keySetView, (String)"buffer.keys");
                    Long l = (Long)CollectionsKt.min((Iterable)keySetView);
                    if (l == null) {
                        break;
                    }
                    long id = l;
                    if (!(Intrinsics.areEqual((Object)((Optional)SourceCore.access$getBuffer$p(this.this$0).remove(id)), null) ^ true)) continue;
                    SourceCore.access$getRemoveCount$p(this.this$0).incrementAndGet();
                }
            }
            {
                this.this$0 = sourceCore;
                super(0);
            }
        }));
        return newId;
    }

    @NotNull
    public final Object get(long id) {
        Optional<T> optional = this.buffer.get(id);
        return optional != null ? optional.unbox-impl() : Optional.Companion.otherwise();
    }

    @NotNull
    public final Object get() {
        Collection<Optional<T>> collection = this.buffer.values();
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"buffer.values");
        Optional optional = (Optional)CollectionsKt.firstOrNull((Iterable)collection);
        return optional != null ? optional.unbox-impl() : Optional.Companion.otherwise();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public Object consume(long id) {
        Object object;
        Optional<T> optional = this.buffer.remove(id);
        if (optional != null) {
            Optional<T> optional2 = optional;
            boolean bl = false;
            boolean bl2 = false;
            Object it = optional2.unbox-impl();
            boolean bl3 = false;
            this.removeCount.incrementAndGet();
            optional = optional2;
            if (optional != null) {
                object = optional.unbox-impl();
                return object;
            }
        }
        object = Optional.Companion.otherwise();
        return object;
    }

    @NotNull
    public final Object consume() {
        Optional<T> optional;
        while (true) {
            ConcurrentHashMap.KeySetView keySetView = (ConcurrentHashMap.KeySetView)this.buffer.keySet();
            Intrinsics.checkExpressionValueIsNotNull((Object)keySetView, (String)"buffer.keys");
            Long l = (Long)CollectionsKt.min((Iterable)keySetView);
            if (l == null) {
                return Optional.Companion.otherwise();
            }
            long id = l;
            optional = this.buffer.remove(id);
            if (optional == null) continue;
            Optional<T> optional2 = optional;
            boolean bl = false;
            boolean bl2 = false;
            Object it = optional2.unbox-impl();
            boolean bl3 = false;
            this.removeCount.incrementAndGet();
            optional = optional2;
            if (optional != null) break;
        }
        return optional.unbox-impl();
    }

    public final void clear() {
        this.buffer.clear();
    }

    public SourceCore(int size) {
        this.size = size;
        this.lastId = new AtomicLong(0L);
        if (this.size <= 0) {
            throw (Throwable)new IllegalArgumentException("size must be greater than 0");
        }
        this.buffer = this.size <= 16 ? new ConcurrentHashMap(16) : new ConcurrentHashMap();
        this.removeCount = new AtomicLong(0L);
        this.lock = new ReentrantLock();
    }

    public static final /* synthetic */ int access$getSize$p(SourceCore $this) {
        return $this.size;
    }

    public static final /* synthetic */ ConcurrentHashMap access$getBuffer$p(SourceCore $this) {
        return $this.buffer;
    }

    public static final /* synthetic */ AtomicLong access$getRemoveCount$p(SourceCore $this) {
        return $this.removeCount;
    }
}

