/*
 * Decompiled with CFR 0.152.
 */
package org.mechdancer.dataflow.core.internal;

import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.mechdancer.common.extension.Optional;
import org.mechdancer.dataflow.core.BuildersKt;
import org.mechdancer.dataflow.core.Feedback;
import org.mechdancer.dataflow.core.UUIDBase;
import org.mechdancer.dataflow.core.intefaces.ILink;
import org.mechdancer.dataflow.core.intefaces.IPostable;
import org.mechdancer.dataflow.core.intefaces.ISource;
import org.mechdancer.dataflow.core.intefaces.ITarget;
import org.mechdancer.dataflow.core.intefaces.IWithUUID;
import org.mechdancer.dataflow.core.options.LinkOptions;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\u00020\u0003B/\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\"\u001a\u00020#H\u0016J\u0011\u0010$\u001a\u00020\u00132\u0006\u0010%\u001a\u00020\u0003H\u0096\u0003J\u001f\u0010&\u001a\b\u0012\u0004\u0012\u00028\u00000'2\u0006\u0010(\u001a\u00020)H\u0096\u0004\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010*J\u0011\u0010+\u001a\u00020,2\u0006\u0010(\u001a\u00020)H\u0096\u0004J\b\u0010-\u001a\u00020.H\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0015R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0012\u0010\u001e\u001a\u00020\u001fX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b \u0010!\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006/"}, d2={"Lorg/mechdancer/dataflow/core/internal/Link;", "T", "Lorg/mechdancer/dataflow/core/intefaces/ILink;", "Lorg/mechdancer/dataflow/core/intefaces/IWithUUID;", "source", "Lorg/mechdancer/dataflow/core/intefaces/ISource;", "target", "Lorg/mechdancer/dataflow/core/intefaces/ITarget;", "options", "Lorg/mechdancer/dataflow/core/options/LinkOptions;", "(Lorg/mechdancer/dataflow/core/intefaces/ISource;Lorg/mechdancer/dataflow/core/intefaces/ITarget;Lorg/mechdancer/dataflow/core/options/LinkOptions;)V", "_count", "Ljava/util/concurrent/atomic/AtomicInteger;", "<set-?>", "", "closed", "getClosed", "()Z", "count", "", "getCount", "()I", "getOptions", "()Lorg/mechdancer/dataflow/core/options/LinkOptions;", "rest", "getRest", "getSource", "()Lorg/mechdancer/dataflow/core/intefaces/ISource;", "getTarget", "()Lorg/mechdancer/dataflow/core/intefaces/ITarget;", "uuid", "Ljava/util/UUID;", "getUuid", "()Ljava/util/UUID;", "close", "", "compareTo", "other", "consume", "Lorg/mechdancer/common/extension/Optional;", "id", "", "(J)Ljava/lang/Object;", "offer", "Lorg/mechdancer/dataflow/core/Feedback;", "toString", "", "dataflow-jvm"})
public final class Link<T>
implements ILink<T>,
IWithUUID {
    private final AtomicInteger _count;
    private volatile boolean closed;
    @NotNull
    private final ISource<T> source;
    @NotNull
    private final ITarget<T> target;
    @NotNull
    private final LinkOptions<T> options;
    private final /* synthetic */ UUIDBase $$delegate_0;

    @Override
    public int getCount() {
        return this._count.get();
    }

    @Override
    public int getRest() {
        return this.getOptions().getEventLimit() - this._count.get();
    }

    @Override
    public boolean getClosed() {
        return this.closed;
    }

    @Override
    @NotNull
    public Feedback offer(long id) {
        return this.getClosed() ? Feedback.DecliningPermanently : this.getTarget().offer(id, this);
    }

    @Override
    @NotNull
    public Object consume(long id) {
        Object object;
        Object $this$iv = this.getSource().consume(id);
        boolean $i$f$then = false;
        Object it$iv = object = $this$iv;
        boolean bl = false;
        if (!($this$iv instanceof Optional.Void)) {
            Object it = $this$iv;
            boolean bl2 = false;
            if (this._count.incrementAndGet() > this.getOptions().getEventLimit()) {
                this.close();
            }
        }
        return object;
    }

    @Override
    public void close() {
        this.closed = true;
        BuildersKt.post((IPostable)ILink.Companion.getChanged$dataflow_jvm(), this);
    }

    @NotNull
    public String toString() {
        return this.getSource().getName() + " -> " + this.getTarget().getName();
    }

    @Override
    @NotNull
    public ISource<T> getSource() {
        return this.source;
    }

    @Override
    @NotNull
    public ITarget<T> getTarget() {
        return this.target;
    }

    @Override
    @NotNull
    public LinkOptions<T> getOptions() {
        return this.options;
    }

    public Link(@NotNull ISource<T> source, @NotNull ITarget<T> target, @NotNull LinkOptions<T> options) {
        Intrinsics.checkParameterIsNotNull(source, (String)"source");
        Intrinsics.checkParameterIsNotNull(target, (String)"target");
        Intrinsics.checkParameterIsNotNull(options, (String)"options");
        this.$$delegate_0 = new UUIDBase();
        this.source = source;
        this.target = target;
        this.options = options;
        if (Intrinsics.areEqual(this.getSource(), ILink.Companion.getChanged$dataflow_jvm()) ^ true) {
            BuildersKt.post((IPostable)ILink.Companion.getChanged$dataflow_jvm(), this);
        }
        this._count = new AtomicInteger(0);
    }

    @Override
    @NotNull
    public UUID getUuid() {
        return this.$$delegate_0.getUuid();
    }

    @Override
    public int compareTo(@NotNull IWithUUID other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return this.$$delegate_0.compareTo(other);
    }
}

