/*
 * Decompiled with CFR 0.152.
 */
package org.mechdancer.dataflow.core.internal;

import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.mechdancer.dataflow.core.Feedback;
import org.mechdancer.dataflow.core.ILink;
import org.mechdancer.dataflow.core.ISource;
import org.mechdancer.dataflow.core.ITarget;
import org.mechdancer.dataflow.core.IWithUUID;
import org.mechdancer.dataflow.core.LinkOptions;
import org.mechdancer.dataflow.core.Message;
import org.mechdancer.dataflow.core.ShortcutKt;
import org.mechdancer.dataflow.core.internal.LinkManager;
import org.mechdancer.dataflow.core.internal.UtilityKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B=\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\n\u00a2\u0006\u0002\u0010\u000bJ\u0019\u0010\u001e\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u001f2\u0006\u0010 \u001a\u00020!H\u0096\u0004J\b\u0010\"\u001a\u00020#H\u0016J\u0011\u0010$\u001a\u00020%2\u0006\u0010 \u001a\u00020!H\u0096\u0004J\b\u0010&\u001a\u00020'H\u0016R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0011R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u001bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006("}, d2={"Lorg/mechdancer/dataflow/core/internal/Link;", "T", "Lorg/mechdancer/dataflow/core/ILink;", "source", "Lorg/mechdancer/dataflow/core/ISource;", "target", "Lorg/mechdancer/dataflow/core/ITarget;", "options", "Lorg/mechdancer/dataflow/core/LinkOptions;", "holder", "Lorg/mechdancer/dataflow/core/internal/LinkManager;", "(Lorg/mechdancer/dataflow/core/ISource;Lorg/mechdancer/dataflow/core/ITarget;Lorg/mechdancer/dataflow/core/LinkOptions;Lorg/mechdancer/dataflow/core/internal/LinkManager;)V", "_count", "Ljava/util/concurrent/atomic/AtomicInteger;", "count", "", "getCount", "()I", "getOptions", "()Lorg/mechdancer/dataflow/core/LinkOptions;", "rest", "getRest", "getSource", "()Lorg/mechdancer/dataflow/core/ISource;", "getTarget", "()Lorg/mechdancer/dataflow/core/ITarget;", "uuid", "Ljava/util/UUID;", "getUuid", "()Ljava/util/UUID;", "consume", "Lorg/mechdancer/dataflow/core/Message;", "id", "", "dispose", "", "offer", "Lorg/mechdancer/dataflow/core/Feedback;", "toString", "", "dataflow-jvm"})
public final class Link<T>
implements ILink<T> {
    @NotNull
    private final UUID uuid;
    private final AtomicInteger _count;
    @NotNull
    private final ISource<T> source;
    @NotNull
    private final ITarget<T> target;
    @NotNull
    private final LinkOptions<T> options;
    private final LinkManager<T> holder;

    @Override
    @NotNull
    public UUID getUuid() {
        return this.uuid;
    }

    @Override
    public int getCount() {
        return this._count.get();
    }

    @Override
    public int getRest() {
        return this.getOptions().getEventLimit() - this._count.get();
    }

    @Override
    @NotNull
    public Feedback offer(long id) {
        return this.getTarget().offer(id, this);
    }

    @Override
    @NotNull
    public Message<? extends T> consume(long id) {
        Message message;
        Message $receiver = message = this.getSource().consume(id);
        boolean bl = false;
        if ($receiver.getHasValue() && this._count.incrementAndGet() > this.getOptions().getEventLimit()) {
            this.dispose();
        }
        return message;
    }

    @Override
    public void dispose() {
        boolean bl;
        this.holder.remove(this);
        boolean it = bl = ILink.Companion.getList().remove(this);
        boolean bl2 = false;
        if (it) {
            ShortcutKt.post(ILink.Companion.getChanged(), CollectionsKt.toList((Iterable)ILink.Companion.getList()));
        }
    }

    @NotNull
    public String toString() {
        return this.getSource() + " -> " + this.getTarget();
    }

    @Override
    @NotNull
    public ISource<T> getSource() {
        return this.source;
    }

    @Override
    @NotNull
    public ITarget<T> getTarget() {
        return this.target;
    }

    @Override
    @NotNull
    public LinkOptions<T> getOptions() {
        return this.options;
    }

    public Link(@NotNull ISource<T> source, @NotNull ITarget<T> target, @NotNull LinkOptions<T> options, @NotNull LinkManager<T> holder) {
        Intrinsics.checkParameterIsNotNull(source, (String)"source");
        Intrinsics.checkParameterIsNotNull(target, (String)"target");
        Intrinsics.checkParameterIsNotNull(options, (String)"options");
        Intrinsics.checkParameterIsNotNull(holder, (String)"holder");
        this.source = source;
        this.target = target;
        this.options = options;
        this.holder = holder;
        this.uuid = UtilityKt.randomUUID();
        ILink.Companion.getList().add(this);
        ShortcutKt.post(ILink.Companion.getChanged(), CollectionsKt.toList((Iterable)ILink.Companion.getList()));
        this._count = new AtomicInteger(0);
    }

    @Override
    public int compareTo(@NotNull IWithUUID other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return ILink.DefaultImpls.compareTo(this, other);
    }
}

