/*
 * Decompiled with CFR 0.152.
 */
package org.macrocloud.kernel.mp.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.Collection;
import java.util.Date;
import org.macrocloud.kernel.auth.MacroUser;
import org.macrocloud.kernel.auth.utils.AuthUtil;
import org.macrocloud.kernel.mp.base.MacroBaseEntity;
import org.macrocloud.kernel.mp.base.MacroTenantEntity;
import org.macrocloud.kernel.mp.service.MacroBaseService;
import org.macrocloud.kernel.toolkit.utils.DateUtil;
import org.macrocloud.kernel.toolkit.utils.Func;
import org.springframework.validation.annotation.Validated;

@Validated
public class MacroBaseServiceImpl<M extends BaseMapper<T>, T extends MacroTenantEntity>
extends ServiceImpl<M, T>
implements MacroBaseService<T> {
    public boolean save(T entity) {
        this.resolveSaveEntity(entity);
        return super.save(entity);
    }

    public boolean saveBatch(Collection<T> entityList, int batchSize) {
        entityList.forEach(this::resolveSaveEntity);
        return super.saveBatch(entityList, batchSize);
    }

    public boolean updateById(T entity) {
        this.resolveEntity(entity);
        return super.updateById(entity);
    }

    public boolean updateBatchById(Collection<T> entityList, int batchSize) {
        entityList.forEach(this::resolveEntity);
        return super.updateBatchById(entityList, batchSize);
    }

    public boolean saveOrUpdate(T entity) {
        if (((MacroBaseEntity)entity).getId() == null) {
            return this.save(entity);
        }
        return this.updateById(entity);
    }

    public boolean saveOrUpdateBatch(Collection<T> entityList, int batchSize) {
        entityList.forEach(this::resolveEntity);
        return super.saveOrUpdateBatch(entityList, batchSize);
    }

    private void resolveSaveEntity(T entity) {
        MacroUser user = AuthUtil.getUser();
        Date now = DateUtil.now();
        if (user != null) {
            ((MacroBaseEntity)entity).setCreatedBy(user.getUserId());
            ((MacroBaseEntity)entity).setUpdatedBy(user.getUserId());
            ((MacroBaseEntity)entity).setCreateDept(user.getDeptId());
        }
        ((MacroBaseEntity)entity).setCreatedAt(now);
        ((MacroBaseEntity)entity).setUpdatedAt(now);
        ((MacroTenantEntity)entity).setTenantId(Func.toStrWithEmpty((Object)AuthUtil.getTenantId(), (String)"000000"));
    }

    private void resolveEntity(T entity) {
        MacroUser user = AuthUtil.getUser();
        Date now = DateUtil.now();
        if (((MacroBaseEntity)entity).getId() == null) {
            if (user != null) {
                ((MacroBaseEntity)entity).setCreatedBy(user.getUserId());
                ((MacroBaseEntity)entity).setUpdatedBy(user.getUserId());
                ((MacroBaseEntity)entity).setCreateDept(user.getDeptId());
            }
            ((MacroBaseEntity)entity).setCreatedAt(now);
        } else if (user != null) {
            ((MacroBaseEntity)entity).setUpdatedBy(user.getUserId());
        }
        ((MacroBaseEntity)entity).setUpdatedAt(now);
    }
}

