/*
 * Decompiled with CFR 0.152.
 */
package org.macrocloud.kernel.mp.resolver;

import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.macrocloud.kernel.toolkit.utils.ObjectUtil;
import org.macrocloud.kernel.toolkit.utils.StringUtil;
import org.springframework.core.MethodParameter;
import org.springframework.lang.NonNull;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public class PageArgumentResolver
implements HandlerMethodArgumentResolver {
    private static final String ORDER_ASC = "asc";

    public boolean supportsParameter(MethodParameter parameter) {
        return Page.class.equals((Object)parameter.getParameterType());
    }

    public Object resolveArgument(@NonNull MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest request, WebDataBinderFactory binderFactory) {
        String pageParam = request.getParameter("page");
        String sizeParam = request.getParameter("size");
        Object[] sortParam = request.getParameterValues("sort");
        Page page = new Page();
        if (StringUtil.isNotBlank((CharSequence)pageParam)) {
            page.setCurrent(Long.parseLong(pageParam));
        }
        if (StringUtil.isNotBlank((CharSequence)sizeParam)) {
            page.setSize(Long.parseLong(sizeParam));
        }
        if (ObjectUtil.isEmpty((Object[])sortParam)) {
            return page;
        }
        for (Object param : sortParam) {
            if (StringUtil.isBlank((CharSequence)param)) continue;
            String[] split = ((String)param).split(",");
            OrderItem orderItem = new OrderItem();
            orderItem.setColumn(StringUtil.cleanIdentifier((String)split[0]));
            orderItem.setAsc(PageArgumentResolver.isOrderAsc(split));
            page.addOrder(new OrderItem[]{orderItem});
        }
        return page;
    }

    private static boolean isOrderAsc(String[] split) {
        if (split.length < 2) {
            return false;
        }
        return ORDER_ASC.equalsIgnoreCase(split[1]);
    }
}

