/*
 * Decompiled with CFR 0.152.
 */
package org.macrocloud.kernel.mp.plugins;

import com.alibaba.druid.DbType;
import com.alibaba.druid.filter.FilterChain;
import com.alibaba.druid.filter.FilterEventAdapter;
import com.alibaba.druid.proxy.jdbc.JdbcParameter;
import com.alibaba.druid.proxy.jdbc.ResultSetProxy;
import com.alibaba.druid.proxy.jdbc.StatementProxy;
import com.alibaba.druid.sql.SQLUtils;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.macrocloud.kernel.mp.props.MybatisPlusProperties;
import org.macrocloud.kernel.toolkit.utils.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlLogInterceptor
extends FilterEventAdapter {
    private static final Logger log = LoggerFactory.getLogger(SqlLogInterceptor.class);
    private static final SQLUtils.FormatOption FORMAT_OPTION = new SQLUtils.FormatOption(false, false);
    private static final List<String> SQL_LOG_EXCLUDE = new ArrayList<String>(Arrays.asList("ACT_RU_JOB", "ACT_RU_TIMER_JOB"));
    private final MybatisPlusProperties properties;

    public SqlLogInterceptor(MybatisPlusProperties properties) {
        this.properties = properties;
        if (properties.getSqlLogExclude().size() > 0) {
            SQL_LOG_EXCLUDE.addAll(properties.getSqlLogExclude());
        }
    }

    protected void statementExecuteBefore(StatementProxy statement, String sql) {
        statement.setLastExecuteStartNano();
    }

    protected void statementExecuteBatchBefore(StatementProxy statement) {
        statement.setLastExecuteStartNano();
    }

    protected void statementExecuteUpdateBefore(StatementProxy statement, String sql) {
        statement.setLastExecuteStartNano();
    }

    protected void statementExecuteQueryBefore(StatementProxy statement, String sql) {
        statement.setLastExecuteStartNano();
    }

    protected void statementExecuteAfter(StatementProxy statement, String sql, boolean firstResult) {
        statement.setLastExecuteTimeNano();
    }

    protected void statementExecuteBatchAfter(StatementProxy statement, int[] result) {
        statement.setLastExecuteTimeNano();
    }

    protected void statementExecuteQueryAfter(StatementProxy statement, String sql, ResultSetProxy resultSet) {
        statement.setLastExecuteTimeNano();
    }

    protected void statementExecuteUpdateAfter(StatementProxy statement, String sql, int updateCount) {
        statement.setLastExecuteTimeNano();
    }

    public void statement_close(FilterChain chain, StatementProxy statement) {
        if (!this.properties.getSqlLog().booleanValue()) {
            chain.statement_close(statement);
            return;
        }
        if (!log.isInfoEnabled()) {
            chain.statement_close(statement);
            return;
        }
        String sql = statement.getBatchSql();
        if (StringUtil.isEmpty((Object)sql)) {
            chain.statement_close(statement);
            return;
        }
        if (SqlLogInterceptor.excludeSql(sql)) {
            chain.statement_close(statement);
            return;
        }
        int parametersSize = statement.getParametersSize();
        ArrayList<Object> parameters = new ArrayList<Object>(parametersSize);
        for (int i = 0; i < parametersSize; ++i) {
            parameters.add(SqlLogInterceptor.getJdbcParameter(statement.getParameter(i)));
        }
        String dbType = statement.getConnectionProxy().getDirectDataSource().getDbType();
        String formattedSql = SQLUtils.format((String)sql, (DbType)DbType.of((String)dbType), parameters, (SQLUtils.FormatOption)FORMAT_OPTION);
        SqlLogInterceptor.printSql(formattedSql, statement);
        chain.statement_close(statement);
    }

    private static Object getJdbcParameter(JdbcParameter jdbcParam) {
        if (jdbcParam == null) {
            return null;
        }
        Object value = jdbcParam.getValue();
        if (value instanceof TemporalAccessor) {
            return value.toString();
        }
        return value;
    }

    private static void printSql(String sql, StatementProxy statement) {
        String sqlLogger = "\n\n==============  Sql Start  ==============\nExecute SQL : {}\nExecute Time: {}\n==============  Sql  End   ==============\n";
        log.info(sqlLogger, (Object)sql.trim(), (Object)StringUtil.format((long)statement.getLastExecuteTimeNano()));
    }

    private static boolean excludeSql(String sql) {
        for (String exclude : SQL_LOG_EXCLUDE) {
            if (!sql.contains(exclude)) continue;
            return true;
        }
        return false;
    }
}

