package org.macrocloud.kernel.mp.base;

import java.io.Serializable;
import java.util.Date;

import com.baomidou.mybatisplus.annotation.*;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 基础实体类
 *
 * @author macrocloud
 */
@Data
public class MacroBaseEntity implements Serializable {

	private static final long serialVersionUID = 1L;

	@ApiModelProperty(value = "主键id")
	@TableId(value = "id", type = IdType.ASSIGN_ID)
	private String id;

	/**
	 * 创建人
	 */
	@TableField(fill = FieldFill.INSERT)
	private String createdBy;

	/**
	 * 创建时间
	 */
	@TableField(fill = FieldFill.INSERT)
	private Date createdAt;

	/**
	 * 更新人
	 */
	@TableField(fill = FieldFill.INSERT_UPDATE)
	private String updatedBy;

	/**
	 * 更新时间
	 */
	@TableField(fill = FieldFill.INSERT_UPDATE)
	private Date updatedAt;

	/**
	 * 创建人所属部门
	 */
	@TableField(fill = FieldFill.INSERT)
	private String createDept;

	/**
	 * 状态[0:未删除,1:删除]
	 */
	@TableLogic
	private Integer isDeleted;

	/**
	 * 状态[1:正常]
	 */
	@ApiModelProperty(value = "业务状态")
	private Integer status;


}
