package org.macrocloud.kernel.mf.service.impl;

import lombok.SneakyThrows;
import org.macrocloud.kernel.auth.MacroUser;
import org.macrocloud.kernel.auth.utils.AuthUtil;
import org.macrocloud.kernel.mf.base.MacroEntity;
import org.macrocloud.kernel.mf.service.MacroService;
import org.macrocloud.kernel.toolkit.constant.MacroConstant;
import org.macrocloud.kernel.toolkit.utils.BeanUtil;
import org.macrocloud.kernel.toolkit.utils.ClassUtil;
import org.macrocloud.kernel.toolkit.utils.ObjectUtil;
import org.macrocloud.kernel.toolkit.utils.ReflectUtil;
import org.macrocloud.kernel.toolkit.utils.DateUtil;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;

import com.mybatisflex.core.BaseMapper;
import com.mybatisflex.spring.service.impl.ServiceImpl;

import javax.validation.constraints.NotEmpty;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

/**
 * 业务封装基础类
 *
 * @param <M> mapper
 * @param <T> model
 */
@Validated
public class MacroServiceImpl<M extends BaseMapper<T>, T extends MacroEntity> extends ServiceImpl<M, T> implements MacroService<T> {

	@Override
	public boolean save(T entity) {
		this.resolveSaveEntity(entity);
		return super.save(entity);
	}

	@Override
	public boolean saveBatch(Collection<T> entityList, int batchSize) {
		entityList.forEach(this::resolveSaveEntity);
		return super.saveBatch(entityList, batchSize);
	}

	@Override
	public boolean updateById(T entity) {
		this.resolveEntity(entity);
		return super.updateById(entity);
	}

	@Override
	public boolean updateBatch(Collection<T> entityList, int batchSize) {
		entityList.forEach(this::resolveEntity);
		return super.updateBatch(entityList, batchSize);
	}



	@Override
	@Transactional(rollbackFor = Exception.class)
	public boolean deleteLogic(@NotEmpty List<String> ids) {
		MacroUser user = AuthUtil.getUser();
		List<T> list = new ArrayList<>();
		return super.updateBatch(list);
	}

	@Override
	public boolean changeStatus(@NotEmpty List<String> ids, Integer status) {
		MacroUser user = AuthUtil.getUser();
		List<T> list = new ArrayList<>();
		
		return super.updateBatch(list);
	}

	@SneakyThrows
	private void resolveSaveEntity(T entity) {
		MacroUser user = AuthUtil.getUser();
		Date now = DateUtil.now();
		// 处理多租户逻辑，若字段值为空，则不进行操作
		Field field = ReflectUtil.getField(entity.getClass(), MacroConstant.DB_TENANT_KEY);
		if (ObjectUtil.isNotEmpty(field)) {
			Method getTenantId = ClassUtil.getMethod(entity.getClass(), MacroConstant.DB_TENANT_KEY_GET_METHOD);
			String tenantId = String.valueOf(getTenantId.invoke(entity));
			if (ObjectUtil.isEmpty(tenantId)) {
				Method setTenantId = ClassUtil.getMethod(entity.getClass(), MacroConstant.DB_TENANT_KEY_SET_METHOD, String.class);
				setTenantId.invoke(entity, (Object) null);
			}
		}
	}

	@SneakyThrows
	private void resolveEntity(T entity) {
		MacroUser user = AuthUtil.getUser();
		Date now = DateUtil.now();
		// 处理多租户逻辑，若字段值为空，则不进行操作
		Field field = ReflectUtil.getField(entity.getClass(), MacroConstant.DB_TENANT_KEY);
		if (ObjectUtil.isNotEmpty(field)) {
			Method getTenantId = ClassUtil.getMethod(entity.getClass(), MacroConstant.DB_TENANT_KEY_GET_METHOD);
			String tenantId = String.valueOf(getTenantId.invoke(entity));
			if (ObjectUtil.isEmpty(tenantId)) {
				Method setTenantId = ClassUtil.getMethod(entity.getClass(), MacroConstant.DB_TENANT_KEY_SET_METHOD, String.class);
				setTenantId.invoke(entity, (Object) null);
			}
		}
	}

}
