package org.macrocloud.kernel.mf.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

import javax.validation.constraints.NotEmpty;

import org.macrocloud.kernel.auth.MacroUser;
import org.macrocloud.kernel.auth.utils.AuthUtil;
import org.macrocloud.kernel.mf.base.MacroTenantEntity;
import org.macrocloud.kernel.mf.service.MacroBaseService;
import org.macrocloud.kernel.toolkit.constant.MacroConstant;
import org.macrocloud.kernel.toolkit.utils.BeanUtil;
import org.macrocloud.kernel.toolkit.utils.Func;
import org.macrocloud.kernel.toolkit.utils.DateUtil;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;

import com.mybatisflex.core.BaseMapper;
import com.mybatisflex.spring.service.impl.ServiceImpl;

import lombok.SneakyThrows;

/**
 * 业务封装基础类
 *
 * @param <M> mapper
 * @param <T> model
 * @author Chill
 */
@Validated
public class MacroBaseServiceImpl<M extends BaseMapper<T>, T extends MacroTenantEntity> extends ServiceImpl<M, T> implements MacroBaseService<T> {

	@Override
	public boolean save(T entity) {
		this.resolveSaveEntity(entity);
		return super.save(entity);
	}

	@Override
	public boolean saveBatch(Collection<T> entityList, int batchSize) {
		entityList.forEach(this::resolveSaveEntity);
		return super.saveBatch(entityList, batchSize);
	}

	@Override
	public boolean updateById(T entity) {
		this.resolveEntity(entity);
		return super.updateById(entity);
	}

	@Override
	public boolean updateBatch(Collection<T> entityList, int batchSize) {
		entityList.forEach(this::resolveEntity);
		return super.updateBatch(entityList, batchSize);
	}

	@Override
	public boolean saveOrUpdate(T entity) {
		if (entity.getId() == null) {
			return this.save(entity);
		} else {
			return this.updateById(entity);
		}
	}


	@SneakyThrows
	private void resolveSaveEntity(T entity) {
		MacroUser user = AuthUtil.getUser();
		Date now = DateUtil.now();
		// 处理新增逻辑
		if (user != null) {
			entity.setCreatedBy(user.getUserId());
			entity.setUpdatedBy(user.getUserId());
			entity.setCreateDept(user.getDeptId());
		}
		entity.setCreatedAt(now);
		entity.setUpdatedAt(now);
		entity.setTenantId(Func.toStrWithEmpty(AuthUtil.getTenantId(), MacroConstant.ADMIN_TENANT_ID));
	}

	@SneakyThrows
	private void resolveEntity(T entity) {
		MacroUser user = AuthUtil.getUser();
		Date now = DateUtil.now();
		if (entity.getId() == null) {
			// 处理新增逻辑
			if (user != null) {
				entity.setCreatedBy(user.getUserId());
				entity.setUpdatedBy(user.getUserId());
				entity.setCreateDept(user.getDeptId());
			}
			entity.setCreatedAt(now);
		} else if (user != null) {
			// 处理修改逻辑
			entity.setUpdatedBy(user.getUserId());
		}
		// 处理通用逻辑
		entity.setUpdatedAt(now);
	}

}
