package org.macrocloud.kernel.mf.config;

import com.mybatisflex.core.audit.AuditManager;
import com.mybatisflex.core.tenant.TenantFactory;
import com.mybatisflex.core.tenant.TenantManager;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class MybatisFlexConfig {

    private static final Logger logger = LoggerFactory.getLogger("mybatis-flex-sql");

    public MybatisFlexConfig() {
        AuditManager.setAuditEnable(true);
        AuditManager.setMessageCollector(auditMessage ->
                logger.info("{},{}ms", auditMessage.getFullSql(), auditMessage.getElapsedTime())
        );
        
        TenantManager.setTenantFactory(new TenantFactory() {
            @Override
            public Object[] getTenantIds() {
                return new Object[]{000000};
            }
        });
    }
    
}