
package org.macrocloud.kernel.mf.base;


import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

import com.mybatisflex.annotation.Id;


/**
 * 基础实体类
 *
 * @author
 */
@Data
public class BaseEntity implements Serializable {

	@ApiModelProperty(value = "主键id")
	@Id
	private String id;

	/**
	 * 创建人
	 */
	private String createdBy;

	/**
	 * 创建时间
	 */
	private Date createdAt;

	/**
	 * 更新人
	 */
	private String updatedBy;

	/**
	 * 更新时间
	 */
	private Date updatedAt;

	/**
	 * 状态[0:未删除,1:删除]
	 */
	private Integer isDeleted;

	/**
	 * 状态[1:正常]
	 */
	@ApiModelProperty(value = "业务状态")
	private Integer status;

	/**
	 * 创建部门
	 */
	@ApiModelProperty(value = "创建部门")
	private String createDept;
}
