/*
 * Decompiled with CFR 0.152.
 */
package org.linuxprobe.crud.mybatis.session.defaults;

import java.sql.Connection;
import java.sql.SQLException;
import org.apache.ibatis.exceptions.ExceptionFactory;
import org.apache.ibatis.executor.ErrorContext;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.Environment;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.TransactionIsolationLevel;
import org.apache.ibatis.session.defaults.DefaultSqlSessionFactory;
import org.apache.ibatis.transaction.Transaction;
import org.apache.ibatis.transaction.TransactionFactory;
import org.apache.ibatis.transaction.managed.ManagedTransactionFactory;
import org.linuxprobe.crud.core.content.UniversalCrudContent;
import org.linuxprobe.crud.mapper.UniversalMapper;
import org.linuxprobe.crud.mybatis.session.UniversalCrudConfiguration;
import org.linuxprobe.crud.mybatis.session.UniversalCrudSqlSession;
import org.linuxprobe.crud.mybatis.session.UniversalCrudSqlSessionFactory;
import org.linuxprobe.crud.mybatis.session.defaults.UniversalCrudDefaultSqlSession;

public class UniversalCrudDefaultSqlSessionFactory
extends DefaultSqlSessionFactory
implements UniversalCrudSqlSessionFactory {
    public UniversalCrudDefaultSqlSessionFactory(UniversalCrudConfiguration configuration) {
        super((Configuration)configuration);
        if (!configuration.hasMapper(UniversalMapper.class)) {
            configuration.addMapper(UniversalMapper.class);
        }
        UniversalCrudContent.init(configuration);
    }

    @Override
    public UniversalCrudSqlSession openSession() {
        return this.openSessionFromDataSource(this.getConfiguration().getDefaultExecutorType(), null, false);
    }

    @Override
    public UniversalCrudSqlSession openSession(boolean autoCommit) {
        return this.openSessionFromDataSource(this.getConfiguration().getDefaultExecutorType(), null, autoCommit);
    }

    @Override
    public UniversalCrudSqlSession openSession(ExecutorType execType) {
        return this.openSessionFromDataSource(execType, null, false);
    }

    @Override
    public UniversalCrudSqlSession openSession(TransactionIsolationLevel level) {
        return this.openSessionFromDataSource(this.getConfiguration().getDefaultExecutorType(), level, false);
    }

    @Override
    public UniversalCrudSqlSession openSession(ExecutorType execType, TransactionIsolationLevel level) {
        return this.openSessionFromDataSource(execType, level, false);
    }

    @Override
    public UniversalCrudSqlSession openSession(ExecutorType execType, boolean autoCommit) {
        return this.openSessionFromDataSource(execType, null, autoCommit);
    }

    @Override
    public UniversalCrudSqlSession openSession(Connection connection) {
        return this.openSessionFromConnection(this.getConfiguration().getDefaultExecutorType(), connection);
    }

    @Override
    public UniversalCrudSqlSession openSession(ExecutorType execType, Connection connection) {
        return this.openSessionFromConnection(execType, connection);
    }

    private UniversalCrudSqlSession openSessionFromDataSource(ExecutorType execType, TransactionIsolationLevel level, boolean autoCommit) {
        Transaction tx = null;
        try {
            Environment environment = this.getConfiguration().getEnvironment();
            TransactionFactory transactionFactory = this.getTransactionFactoryFromEnvironment(environment);
            tx = transactionFactory.newTransaction(environment.getDataSource(), level, autoCommit);
            Executor executor = this.getConfiguration().newExecutor(tx, execType);
            UniversalCrudDefaultSqlSession universalCrudDefaultSqlSession = new UniversalCrudDefaultSqlSession(this.getConfiguration(), executor, autoCommit);
            return universalCrudDefaultSqlSession;
        }
        catch (Exception e) {
            this.closeTransaction(tx);
            throw ExceptionFactory.wrapException((String)("Error opening session.  Cause: " + e), (Exception)e);
        }
        finally {
            ErrorContext.instance().reset();
        }
    }

    private UniversalCrudSqlSession openSessionFromConnection(ExecutorType execType, Connection connection) {
        try {
            boolean autoCommit;
            try {
                autoCommit = connection.getAutoCommit();
            }
            catch (SQLException e) {
                autoCommit = true;
            }
            Environment environment = this.getConfiguration().getEnvironment();
            TransactionFactory transactionFactory = this.getTransactionFactoryFromEnvironment(environment);
            Transaction tx = transactionFactory.newTransaction(connection);
            Executor executor = this.getConfiguration().newExecutor(tx, execType);
            UniversalCrudDefaultSqlSession universalCrudDefaultSqlSession = new UniversalCrudDefaultSqlSession(this.getConfiguration(), executor, autoCommit);
            return universalCrudDefaultSqlSession;
        }
        catch (Exception e) {
            throw ExceptionFactory.wrapException((String)("Error opening session.  Cause: " + e), (Exception)e);
        }
        finally {
            ErrorContext.instance().reset();
        }
    }

    private TransactionFactory getTransactionFactoryFromEnvironment(Environment environment) {
        if (environment == null || environment.getTransactionFactory() == null) {
            return new ManagedTransactionFactory();
        }
        return environment.getTransactionFactory();
    }

    private void closeTransaction(Transaction tx) {
        if (tx != null) {
            try {
                tx.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    @Override
    public UniversalCrudConfiguration getConfiguration() {
        return (UniversalCrudConfiguration)super.getConfiguration();
    }
}

