package org.linuxprobe.crud.service.impl;

import org.linuxprobe.crud.core.content.UniversalCrudContent;
import org.linuxprobe.crud.core.query.BaseQuery;
import org.linuxprobe.crud.core.query.Page;
import org.linuxprobe.crud.mybatis.spring.UniversalCrudSqlSessionTemplate;
import org.linuxprobe.crud.service.UniversalService;
import org.linuxprobe.crud.service.UniversalServiceEventListener;
import org.linuxprobe.luava.reflection.ReflectionUtils;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * @param <Model>  模型类型
 * @param <IdType> 主键类型
 * @param <Query>  查询类型
 */
public class UniversalServiceImpl<Model, IdType extends Serializable, Query extends BaseQuery>
        implements UniversalService<Model, IdType, Query> {
    public UniversalServiceImpl(UniversalCrudSqlSessionTemplate sqlSessionTemplate) {
        this(sqlSessionTemplate, null);
    }

    public UniversalServiceImpl(UniversalCrudSqlSessionTemplate sqlSessionTemplate, UniversalServiceEventListener eventListener) {
        this.sqlSessionTemplate = sqlSessionTemplate;
        this.eventListener = eventListener;
        this.classLoader = this.getClass().getClassLoader();
    }

    public UniversalCrudSqlSessionTemplate sqlSessionTemplate;

    private UniversalServiceEventListener eventListener;

    private ClassLoader classLoader;

    private Class<?> getModelCalss() {
        Class<?> entityType = UniversalCrudContent.getEntityInfo(ReflectionUtils.getGenericSuperclass(this.getClass(), 0).getName()).getEntityType();
        try {
            entityType = Class.forName(entityType.getName(), true, this.classLoader);
        } catch (ClassNotFoundException ignored) {
        }
        return entityType;
    }

    @Override
    public Model save(Model model) {
        Class<?> thisClass = null;
        Method thisMethod = null;
        if (this.eventListener != null) {
            thisClass = this.getClass();
            thisMethod = new Object() {
            }.getClass().getEnclosingMethod();
            this.eventListener.before(thisClass, thisMethod, model);
        }
        Model result = this.sqlSessionTemplate.insert(model, this.classLoader);
        if (this.eventListener != null) {
            this.eventListener.after(thisClass, thisMethod, result, model);
        }
        return result;
    }

    @Override
    public List<Model> batchSave(List<Model> models, boolean loop) {
        Class<?> thisClass = null;
        Method thisMethod = null;
        if (this.eventListener != null) {
            thisClass = this.getClass();
            thisMethod = new Object() {
            }.getClass().getEnclosingMethod();
            this.eventListener.before(thisClass, thisMethod, models, loop);
        }
        List<Model> result = this.sqlSessionTemplate.batchInsert(models, loop, this.classLoader);
        if (this.eventListener != null) {
            this.eventListener.after(thisClass, thisMethod, result, models, loop);
        }
        return result;
    }

    @Override
    public int removeByPrimaryKey(IdType id) {
        Class<?> modelClass = this.getModelCalss();
        return this.sqlSessionTemplate.deleteByPrimaryKey(id, modelClass);
    }

    @Override
    public long batchRemoveByPrimaryKey(List<IdType> ids) throws Exception {
        Class<?> modelClass = this.getModelCalss();
        return this.sqlSessionTemplate.batchDeleteByPrimaryKey((Collection<Serializable>) ids, modelClass);
    }

    @Override
    public int remove(Model record) {
        return this.sqlSessionTemplate.delete(record);
    }

    @Override
    public int batchRemove(List<Model> records) {
        return this.sqlSessionTemplate.batchDelete(records);
    }

    @Override
    public int removeByColumnName(String columnName, Serializable columnValue) {
        return this.sqlSessionTemplate.deleteByColumnName(columnName, columnValue, this.getModelCalss());
    }

    @Override
    public int removeByColumnNames(String[] columnNames, Serializable[] columnValues) {
        return this.sqlSessionTemplate.deleteByColumnNames(columnNames, columnValues, this.getModelCalss());
    }

    @Override
    public int removeyByFieldName(String fieldName, Serializable fieldValue) {
        return this.sqlSessionTemplate.deleteByFieldName(fieldName, fieldValue, this.getModelCalss());
    }

    @Override
    public int removeByFieldNames(String[] fieldNames, Serializable[] fieldValues) {
        return this.sqlSessionTemplate.deleteByFieldNames(fieldNames, fieldValues, this.getModelCalss());
    }

    @Override
    public Model getByPrimaryKey(IdType id) {
        Class<?> modelClass = this.getModelCalss();
        Model model = (Model) this.sqlSessionTemplate.selectByPrimaryKey(id, modelClass, this.classLoader);
        return model;
    }

    @Override
    public List<Model> getByQueryParam(Query param) {
        return (List<Model>) this.sqlSessionTemplate.universalSelect(param, this.classLoader);
    }

    @Override
    public long getCountByQueryParam(Query param) {
        return this.sqlSessionTemplate.selectCount(param);
    }

    @Override
    public Page<Model> getPageInfo(Query param) {
        Page<Model> result = new Page<>();
        if (param.getLimit() != null) {
            result.setCurrentPage(param.getLimit().getCurrentPage());
            result.setPageSize(param.getLimit().getPageSize());
        }
        result.setData(this.getByQueryParam(param));
        result.setTotal(this.getCountByQueryParam(param));
        return result;
    }

    @Override
    public List<Map<String, Object>> getBySql(String sql) {
        return this.sqlSessionTemplate.selectBySql(sql);
    }

    @Override
    public Map<String, Object> getOneBySql(String sql) {
        return this.sqlSessionTemplate.selectOneBySql(sql);
    }

    @Override
    public <T> List<T> getBySql(String sql, Class<T> type) {
        return this.sqlSessionTemplate.selectBySql(sql, type, this.classLoader);
    }

    @Override
    public <T> T getOneBySql(String sql, Class<T> type) {
        return this.sqlSessionTemplate.selectOneBySql(sql, type, this.classLoader);
    }

    @Override
    public List<Model> getByColumn(String column, Serializable columnValue) {
        return (List<Model>) this.sqlSessionTemplate.selectByColumn(column, columnValue, this.getModelCalss(), this.classLoader);
    }

    @Override
    public List<Model> getByFiled(String fieldName, Serializable fieldValue) {
        return (List<Model>) this.sqlSessionTemplate.selectByField(fieldName, fieldValue, this.getModelCalss(), this.classLoader);
    }

    @Override
    public Model getOneByColumn(String column, Serializable columnValue) {
        return (Model) this.sqlSessionTemplate.selectOneByColumn(column, columnValue, this.getModelCalss(), this.classLoader);
    }

    @Override
    public Model getOneByFiled(String fieldName, Serializable fieldValue) {
        return (Model) this.sqlSessionTemplate.selectOneByField(fieldName, fieldValue, this.getModelCalss(), this.classLoader);
    }

    @Override
    public Model globalUpdate(Model model) {
        Method thisMethod = null;
        if (this.eventListener != null) {
            thisMethod = new Object() {
            }.getClass().getEnclosingMethod();
            this.eventListener.before(this.getClass(), thisMethod, model);
        }
        Model result = this.sqlSessionTemplate.globalUpdate(model, this.classLoader);
        if (this.eventListener != null) {
            this.eventListener.after(this.getClass(), thisMethod, result, model);
        }
        return result;
    }

    @Override
    public Model localUpdate(Model model) {
        Method thisMethod = null;
        if (this.eventListener != null) {
            thisMethod = new Object() {
            }.getClass().getEnclosingMethod();
            this.eventListener.before(this.getClass(), thisMethod, model);
        }
        Model result = this.sqlSessionTemplate.localUpdate(model, this.classLoader);
        if (this.eventListener != null) {
            this.eventListener.after(this.getClass(), thisMethod, result, model);
        }
        return result;
    }
}
