/*
 * Decompiled with CFR 0.152.
 */
package org.linuxprobe.crud.core.query.param;

import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;

public abstract class BaseParam<T extends Serializable> {
    private Operator operator = Operator.equal;
    private Condition condition = Condition.and;

    public boolean isEmpty() {
        Operator operator = this.getOperator();
        if (Operator.isNull.equals(operator) || Operator.isNotNull.equals(operator)) {
            return false;
        }
        if (Operator.between.equals(operator) || Operator.notBetween.equals(operator)) {
            return this.getMinValue() == null || this.getMaxValue() == null;
        }
        if (Operator.in.equals(operator) || Operator.notIn.equals(operator)) {
            return this.getMultiValues() == null || this.getMultiValues().isEmpty();
        }
        return this.getValue() == null;
    }

    public abstract T getValue();

    public abstract T getMinValue();

    public abstract T getMaxValue();

    public abstract List<T> getMultiValues();

    public Class<?> getParamCalss() {
        Type type = ((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        Class<?> modelClass = null;
        try {
            modelClass = Class.forName(type.getTypeName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return modelClass;
    }

    public void setOperator(Operator operator) {
        this.operator = operator == null ? Operator.equal : operator;
    }

    public void setCondition(Condition condition) {
        this.condition = condition == null ? Condition.and : condition;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public Condition getCondition() {
        return this.condition;
    }

    public static class Condition {
        private String condition;
        public static final Condition and = new Condition("AND");
        public static final Condition or = new Condition("OR");

        private Condition(String condition) {
            this.condition = condition;
        }

        public String toString() {
            return this.condition;
        }

        public String getCondition() {
            return this.condition;
        }
    }

    public static class Operator {
        private String operator = "=";
        public static final Operator equal = new Operator("equal");
        public static final Operator unequal = new Operator("unequal");
        public static final Operator more = new Operator("more");
        public static final Operator less = new Operator("less");
        public static final Operator moreOrEqual = new Operator("moreOrEqual");
        public static final Operator lessOrEqual = new Operator("lessOrEqual");
        public static final Operator between = new Operator("between");
        public static final Operator notBetween = new Operator("notBetween");
        public static final Operator in = new Operator("in");
        public static final Operator notIn = new Operator("notIn");
        public static final Operator like = new Operator("like");
        public static final Operator unlike = new Operator("unlike");
        public static final Operator isNull = new Operator("isNull");
        public static final Operator isNotNull = new Operator("isNotNull");
        public static final Operator regexp = new Operator("regexp");

        private Operator(String operator) {
            if ("equal".equals(operator)) {
                this.operator = "=";
            } else if ("unequal".equals(operator)) {
                this.operator = "!=";
            } else if ("more".equals(operator)) {
                this.operator = ">";
            } else if ("less".equals(operator)) {
                this.operator = "<";
            } else if ("moreOrEqual".equals(operator)) {
                this.operator = ">=";
            } else if ("lessOrEqual".equals(operator)) {
                this.operator = "<=";
            } else if ("between".equals(operator)) {
                this.operator = "BETWEEN";
            } else if ("notBetween".equals(operator)) {
                this.operator = "NOT BETWEEN";
            } else if ("in".equals(operator)) {
                this.operator = "IN";
            } else if ("notIn".equals(operator)) {
                this.operator = "NOT IN";
            } else if ("like".equals(operator)) {
                this.operator = "LIKE";
            } else if ("unlike".equals(operator)) {
                this.operator = "NOT LIKE";
            } else if ("isNull".equals(operator)) {
                this.operator = "IS";
            } else if ("isNotNull".equals(operator)) {
                this.operator = "IS NOT";
            } else if ("regexp".equals(operator)) {
                this.operator = "REGEXP";
            } else {
                throw new IllegalArgumentException("can't support operator '" + operator + "'");
            }
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = prime * result + (this.operator == null ? 0 : this.operator.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Operator other = (Operator)obj;
            return !(this.operator == null ? other.operator != null : !this.operator.equals(other.operator));
        }

        public String getOperator() {
            return this.operator;
        }
    }
}

