/*
 * Decompiled with CFR 0.152.
 */
package org.linuxprobe.crud.core.sql.generator.impl.mysql;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.linuxprobe.crud.core.content.EntityInfo;
import org.linuxprobe.crud.core.content.UniversalCrudContent;
import org.linuxprobe.crud.core.sql.generator.Escape;
import org.linuxprobe.crud.core.sql.generator.InsertSqlGenerator;
import org.linuxprobe.crud.core.sql.generator.impl.mysql.MysqlEscape;
import org.linuxprobe.crud.core.sql.generator.impl.mysql.MysqlFieldValueConversion;
import org.linuxprobe.crud.exception.OperationNotSupportedException;

public class MysqlInsertSqlGenerator
extends MysqlEscape
implements InsertSqlGenerator,
Escape {
    @Override
    public String toBatchInsertSql(Collection<?> records) {
        if (records == null || records.isEmpty()) {
            throw new OperationNotSupportedException("\u6ca1\u6709\u9700\u8981\u88ab\u4fdd\u5b58\u7684\u5b9e\u4f53");
        }
        StringBuilder sqlBuilder = new StringBuilder();
        Iterator<?> iterator = records.iterator();
        boolean isFisrtLoop = true;
        while (iterator.hasNext()) {
            Object entity = iterator.next();
            if (isFisrtLoop) {
                sqlBuilder.append(this.toInsertSql(entity));
            } else {
                String sql = this.toInsertSql(entity);
                String sqlValue = sql.substring(sql.indexOf("VALUES") + 6);
                sqlBuilder.append(", " + sqlValue);
            }
            isFisrtLoop = false;
        }
        return sqlBuilder.toString();
    }

    @Override
    public String toInsertSql(Object record) {
        EntityInfo entityInfo = UniversalCrudContent.getEntityInfo(record.getClass());
        String table = entityInfo.getTableName();
        StringBuilder sqlBuilder = new StringBuilder("INSERT INTO `" + table + "` ");
        StringBuilder clounms = new StringBuilder("(");
        StringBuilder values = new StringBuilder(" VALUES(");
        List<EntityInfo.FieldInfo> fieldInfos = entityInfo.getFieldInfos();
        if (fieldInfos == null || fieldInfos.isEmpty()) {
            throw new OperationNotSupportedException("\u8be5\u5b9e\u4f53\u7c7b\u6ca1\u6709\u4efb\u4f55\u5b57\u6bb5");
        }
        for (int i = 0; i < fieldInfos.size(); ++i) {
            EntityInfo.FieldInfo fieldInfo = fieldInfos.get(i);
            String fieldValue = MysqlFieldValueConversion.insertModelConversion(record, fieldInfo.getField());
            if (i + 1 == fieldInfos.size()) {
                clounms.append("`" + fieldInfo.getColumnName() + "`)");
                values.append(fieldValue + ")");
                continue;
            }
            clounms.append("`" + fieldInfo.getColumnName() + "`, ");
            values.append(fieldValue + ", ");
        }
        sqlBuilder.append((CharSequence)clounms);
        sqlBuilder.append((CharSequence)values);
        return sqlBuilder.toString();
    }
}

