/*
 * Decompiled with CFR 0.152.
 */
package org.linuxprobe.crud.core.proxy;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.NavigableSet;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeSet;
import java.util.Vector;
import org.linuxprobe.crud.core.annoatation.ManyToMany;
import org.linuxprobe.crud.core.annoatation.OneToMany;
import org.linuxprobe.crud.core.annoatation.OneToOne;
import org.linuxprobe.crud.core.content.EntityInfo;
import org.linuxprobe.crud.core.content.UniversalCrudContent;
import org.linuxprobe.crud.mybatis.session.SqlSessionExtend;
import org.linuxprobe.luava.proxy.AbstractMethodInterceptor;
import org.linuxprobe.luava.proxy.CglibJoinPoint;
import org.linuxprobe.luava.reflection.ReflectionUtils;
import org.linuxprobe.luava.string.StringUtils;
import org.springframework.cglib.proxy.MethodProxy;

public class ModelCglib
extends AbstractMethodInterceptor {
    private SqlSessionExtend sqlSessionExtend;
    private Set<String> handledMethod = new HashSet<String>();

    public ModelCglib(SqlSessionExtend sqlSessionExtend) {
        this.sqlSessionExtend = sqlSessionExtend;
    }

    public boolean preHandle(CglibJoinPoint joinPoint) throws Throwable {
        return true;
    }

    public void afterCompletion(CglibJoinPoint joinPoint) throws Throwable {
        Method method = joinPoint.getMethod();
        MethodProxy methodProxy = joinPoint.getMethodProxy();
        Object result = joinPoint.getResult();
        Object obj = joinPoint.getProxy();
        Object[] args = joinPoint.getArgs();
        if (result == null && !this.handledMethod.contains(method.getName())) {
            if (method.getName().startsWith("set")) {
                this.handledMethod.add(method.getName().replace("set", "get"));
            } else if (method.getName().startsWith("get")) {
                Field field = ReflectionUtils.getFieldByMethod(obj.getClass(), (Method)method);
                if (field.isAnnotationPresent(OneToOne.class)) {
                    this.handledMethod.add(method.getName());
                    this.handldeOneToOne(obj, field);
                    joinPoint.setResult(methodProxy.invokeSuper(obj, args));
                } else if (field.isAnnotationPresent(OneToMany.class)) {
                    this.handledMethod.add(method.getName());
                    this.handldeOneToMany(obj, field);
                    joinPoint.setResult(methodProxy.invokeSuper(obj, args));
                } else if (field.isAnnotationPresent(ManyToMany.class)) {
                    this.handledMethod.add(method.getName());
                    this.handldeManyToMany(obj, field);
                    joinPoint.setResult(methodProxy.invokeSuper(obj, args));
                }
            }
        }
    }

    private Object handldeOneToOne(Object obj, Field field) throws Exception {
        EntityInfo.FieldInfo correlationFieldInfo;
        String columnName = StringUtils.humpToLine((String)field.getName()) + "_id";
        if (!field.getAnnotation(OneToOne.class).value().isEmpty()) {
            columnName = field.getAnnotation(OneToOne.class).value();
        }
        if ((correlationFieldInfo = UniversalCrudContent.getEntityInfo(obj.getClass()).getColumnMapFieldInfo().get(columnName)) == null) {
            throw new IllegalArgumentException(columnName + " column does not have a corresponding field.");
        }
        Serializable correlationFieldValue = (Serializable)ReflectionUtils.getFieldValue((Object)obj, (Field)correlationFieldInfo.getField());
        if (correlationFieldValue != null) {
            Object result = this.sqlSessionExtend.selectByPrimaryKey(correlationFieldValue, field.getType());
            ReflectionUtils.setFieldValue((Object)obj, (Field)field, result, (boolean)true);
            return result;
        }
        return null;
    }

    private Object handldeOneToMany(Object obj, Field field) throws Exception {
        if (!Collection.class.isAssignableFrom(field.getType())) {
            throw new IllegalArgumentException("in " + obj.getClass().getName() + " " + field.getType().getName() + " must be a subclass of " + Collection.class.getName());
        }
        Field principalField = UniversalCrudContent.getEntityInfo(obj.getClass()).getPrimaryKey().getField();
        String subordinateColumn = UniversalCrudContent.getEntityInfo(obj.getClass()).getTableName() + "_id";
        OneToMany oneToMany = field.getAnnotation(OneToMany.class);
        EntityInfo entityInfo = UniversalCrudContent.getEntityInfo(obj.getClass());
        if (!"".equals(oneToMany.value())) {
            principalField = entityInfo.getColumnMapFieldInfo().get(oneToMany.value()).getField();
        } else if (!"".equals(oneToMany.principal())) {
            principalField = entityInfo.getColumnMapFieldInfo().get(oneToMany.principal()).getField();
        }
        if (!"".equals(oneToMany.subordinate())) {
            subordinateColumn = oneToMany.subordinate();
        }
        Class subordinateClass = ReflectionUtils.getFiledGenericclass((Field)field, (int)0);
        Serializable principalFieldValue = (Serializable)ReflectionUtils.getFieldValue((Object)obj, (Field)principalField);
        if (principalFieldValue == null) {
            return null;
        }
        List<Object> daoResults = this.sqlSessionExtend.selectByColumn(subordinateColumn, principalFieldValue, subordinateClass);
        Collection<?> result = this.resultConvert(daoResults, field);
        if (result != null && !result.isEmpty()) {
            ReflectionUtils.setFieldValue((Object)obj, (Field)field, result, (boolean)true);
        } else {
            result = null;
        }
        return result;
    }

    private Object handldeManyToMany(Object obj, Field field) throws Exception {
        String sql;
        List<Object> datas;
        Collection<?> result;
        if (!Collection.class.isAssignableFrom(field.getType())) {
            throw new IllegalArgumentException("in " + obj.getClass().getName() + " " + field.getType().getName() + " must be a subclass of " + Collection.class.getName());
        }
        EntityInfo entityInfo = UniversalCrudContent.getEntityInfo(obj.getClass());
        String currentTable = entityInfo.getTableName();
        Serializable primaryKey = (Serializable)ReflectionUtils.getFieldValue((Object)obj, (Field)entityInfo.getPrimaryKey().getField());
        Class needSelectModelType = ReflectionUtils.getFiledGenericclass((Field)field, (int)0);
        EntityInfo needSelectEntityInfo = UniversalCrudContent.getEntityInfo(needSelectModelType);
        String needSelectTable = needSelectEntityInfo.getTableName();
        String middleTable = currentTable + "_" + needSelectTable;
        String joinColumn = needSelectTable + "_id";
        String conditionColumn = entityInfo.getTableName() + "_id";
        ManyToMany manyToMany = field.getAnnotation(ManyToMany.class);
        if (!manyToMany.middleTable().isEmpty()) {
            middleTable = manyToMany.middleTable();
        }
        if (!manyToMany.joinColumn().isEmpty()) {
            joinColumn = manyToMany.joinColumn();
        }
        if (!manyToMany.conditionColumn().isEmpty()) {
            conditionColumn = manyToMany.conditionColumn();
        }
        if ((result = this.resultConvert(datas = this.sqlSessionExtend.selectBySql(sql = UniversalCrudContent.getSelectSqlGenerator().generateManyToManySelectSql(middleTable, joinColumn, conditionColumn, primaryKey, needSelectModelType), needSelectModelType), field)) != null && !result.isEmpty()) {
            ReflectionUtils.setFieldValue((Object)obj, (Field)field, result, (boolean)true);
        } else {
            result = null;
        }
        return result;
    }

    private Collection<?> resultConvert(List<Object> datas, Field field) {
        Collection<Object> result = datas;
        if (!Collection.class.isAssignableFrom(field.getType())) {
            throw new IllegalArgumentException(field.getType() + "\u662f\u4e0d\u88ab\u652f\u6301\u7684\u7c7b\u578b");
        }
        if (ArrayList.class.isAssignableFrom(field.getType())) {
            result = new ArrayList<Object>(datas);
        } else if (LinkedList.class.isAssignableFrom(field.getType())) {
            result = new LinkedList<Object>(datas);
        } else if (Stack.class.isAssignableFrom(field.getType())) {
            Stack<Object> stack = new Stack<Object>();
            stack.addAll(datas);
            result = stack;
        } else if (Vector.class.isAssignableFrom(field.getType())) {
            Vector<Object> vector = new Vector<Object>();
            vector.addAll(datas);
            result = vector;
        } else if (List.class.isAssignableFrom(field.getType())) {
            result = new LinkedList<Object>(datas);
        } else if (LinkedHashSet.class.isAssignableFrom(field.getType())) {
            result = new LinkedHashSet<Object>(datas);
        } else if (HashSet.class.isAssignableFrom(field.getType())) {
            result = new HashSet<Object>(datas);
        } else if (TreeSet.class.isAssignableFrom(field.getType())) {
            result = new TreeSet<Object>(datas);
        } else if (NavigableSet.class.isAssignableFrom(field.getType())) {
            result = new TreeSet<Object>(datas);
        } else if (SortedSet.class.isAssignableFrom(field.getType())) {
            result = new TreeSet<Object>(datas);
        } else if (Set.class.isAssignableFrom(field.getType())) {
            result = new HashSet<Object>(datas);
        } else if (Queue.class.isAssignableFrom(field.getType())) {
            PriorityQueue<Object> priorityQueue = new PriorityQueue<Object>();
            priorityQueue.addAll(datas);
            result = priorityQueue;
        } else if (Deque.class.isAssignableFrom(field.getType())) {
            ArrayDeque<Object> arrayDeque = new ArrayDeque<Object>();
            arrayDeque.addAll(datas);
            result = arrayDeque;
        }
        return result;
    }

    public void copy(Object source) {
        Class realCalss = ReflectionUtils.getRealCalssOfProxyClass(this.getInstance().getClass());
        if (!source.getClass().getName().equals(realCalss.getName())) {
            throw new IllegalArgumentException("instance attributes of " + source.getClass().getName() + " cannot be copied to " + realCalss.getName() + " object");
        }
        List fields = ReflectionUtils.getAllFields(source.getClass());
        for (Field field : fields) {
            int modifiers = field.getModifiers();
            if (Modifier.isStatic(modifiers) || Modifier.isFinal(modifiers)) continue;
            field.setAccessible(true);
            try {
                field.set(this.getInstance(), field.get(source));
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {}
        }
    }

    public void cleanMark() {
        this.handledMethod.clear();
    }
}

