/*
 * Decompiled with CFR 0.152.
 */
package org.linuxprobe.crud.core.sql.generator.impl.mysql;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.linuxprobe.crud.core.annoatation.Query;
import org.linuxprobe.crud.core.content.EntityInfo;
import org.linuxprobe.crud.core.content.QueryInfo;
import org.linuxprobe.crud.core.content.UniversalCrudContent;
import org.linuxprobe.crud.core.query.BaseQuery;
import org.linuxprobe.crud.core.query.param.BaseParam;
import org.linuxprobe.crud.core.query.param.impl.BooleanParam;
import org.linuxprobe.crud.core.query.param.impl.DateParam;
import org.linuxprobe.crud.core.query.param.impl.NumberParam;
import org.linuxprobe.crud.core.query.param.impl.StringParam;
import org.linuxprobe.crud.core.sql.generator.Escape;
import org.linuxprobe.crud.core.sql.generator.SelectSqlGenerator;
import org.linuxprobe.crud.core.sql.generator.impl.mysql.MysqlEscape;
import org.linuxprobe.luava.reflection.ReflectionUtils;
import org.springframework.util.StringUtils;

public class MysqlSelectSqlGenerator
extends MysqlEscape
implements SelectSqlGenerator,
Escape {
    @Override
    public String toSelectSql(BaseQuery searcher) {
        if (searcher == null) {
            throw new IllegalArgumentException("searcher cannot be null");
        }
        String alias = searcher.getAlias();
        StringBuilder sqlBuilder = new StringBuilder("SELECT DISTINCT `");
        sqlBuilder.append(alias);
        sqlBuilder.append("`.* FROM `");
        sqlBuilder.append(MysqlSelectSqlGenerator.getTable(searcher.getClass()));
        sqlBuilder.append("` AS `");
        sqlBuilder.append(searcher.getAlias());
        sqlBuilder.append("` ");
        sqlBuilder.append((CharSequence)MysqlSelectSqlGenerator.toJoin(searcher));
        sqlBuilder.append((CharSequence)this.getFormatWhere(searcher));
        sqlBuilder.append((CharSequence)MysqlSelectSqlGenerator.toOrder(searcher));
        sqlBuilder.append(MysqlSelectSqlGenerator.toLimit(searcher));
        return sqlBuilder.toString();
    }

    @Override
    public String toSelectSql(Serializable id, Class<?> modelType) {
        if (id == null) {
            throw new IllegalArgumentException("id cannot be null");
        }
        if (id instanceof String && "".equals(id)) {
            throw new IllegalArgumentException("id cannot be empty");
        }
        if (modelType == null) {
            throw new IllegalArgumentException("modelType cannot be null");
        }
        EntityInfo entityInfo = UniversalCrudContent.getEntityInfo(modelType);
        String table = entityInfo.getTableName();
        String idColumn = entityInfo.getPrimaryKey().getColumnName();
        if (String.class.isAssignableFrom(id.getClass())) {
            id = super.escape((String)id);
            id = super.getQuotation() + id + super.getQuotation();
        }
        String sql = "SELECT * FROM `" + table + "` WHERE `" + idColumn + "` = " + id;
        return sql;
    }

    @Override
    public String toSelectSql(String column, Serializable columnValue, boolean singleResult, Class<?> modelType) {
        if (column == null) {
            throw new IllegalArgumentException("column cannot be null");
        }
        if (columnValue == null) {
            throw new IllegalArgumentException("columnValue cannot be null");
        }
        if (columnValue instanceof String && "".equals(columnValue)) {
            throw new IllegalArgumentException("columnValue cannot be empty");
        }
        if (modelType == null) {
            throw new IllegalArgumentException("modelType cannot be null");
        }
        EntityInfo entityInfo = UniversalCrudContent.getEntityInfo(modelType);
        String table = entityInfo.getTableName();
        if (String.class.isAssignableFrom(columnValue.getClass())) {
            columnValue = super.escape((String)columnValue);
            columnValue = super.getQuotation() + columnValue + super.getQuotation();
        }
        String sql = "SELECT * FROM `" + table + "` WHERE `" + column + "` = " + columnValue;
        if (singleResult) {
            sql = sql + " LIMIT 1";
        }
        return sql;
    }

    @Override
    public String toSelectSqlByFieldName(String fieldName, Serializable fieldValue, boolean singleResult, Class<?> modelType) {
        if (fieldName == null) {
            throw new IllegalArgumentException("fieldName cannot be null");
        }
        if (fieldValue == null) {
            throw new IllegalArgumentException("fieldValue cannot be null");
        }
        if (modelType == null) {
            throw new IllegalArgumentException("modelType cannot be null");
        }
        EntityInfo entityInfo = UniversalCrudContent.getEntityInfo(modelType);
        List<EntityInfo.FieldInfo> fieldInfos = entityInfo.getFieldInfos();
        String columnName = null;
        for (EntityInfo.FieldInfo fieldInfo : fieldInfos) {
            if (!fieldInfo.getField().getName().equals(fieldName)) continue;
            columnName = fieldInfo.getColumnName();
        }
        if (columnName == null) {
            throw new IllegalArgumentException(fieldName + " is not " + modelType.getName() + " field");
        }
        return this.toSelectSql(columnName, fieldValue, singleResult, modelType);
    }

    @Override
    public String toSelectCountSql(BaseQuery searcher, String clounm) {
        if (searcher == null) {
            throw new IllegalArgumentException("searcher cannot be null");
        }
        if (clounm == null) {
            throw new IllegalArgumentException("clounm cannot be null");
        }
        String alias = searcher.getAlias();
        String countFun = "COUNT(DISTINCT `" + alias + "`.`" + clounm + "`)";
        StringBuilder sqlBuilder = new StringBuilder("SELECT " + countFun + " FROM `" + MysqlSelectSqlGenerator.getTable(searcher.getClass()) + "` AS `" + alias + "` ");
        sqlBuilder.append((CharSequence)MysqlSelectSqlGenerator.toJoin(searcher));
        sqlBuilder.append((CharSequence)this.getFormatWhere(searcher));
        return sqlBuilder.toString();
    }

    @Override
    public String toSelectCountSql(BaseQuery searcher) {
        if (searcher == null) {
            throw new IllegalArgumentException("searcher cannot be null");
        }
        String alias = searcher.getAlias();
        String countFun = "COUNT(DISTINCT `" + alias + "`.`" + MysqlSelectSqlGenerator.getPrimaryKeyName(MysqlSelectSqlGenerator.getModelType(searcher.getClass())) + "`)";
        StringBuilder sqlBuilder = new StringBuilder("SELECT " + countFun + " FROM `" + MysqlSelectSqlGenerator.getTable(searcher.getClass()) + "` AS `" + alias + "` ");
        sqlBuilder.append((CharSequence)MysqlSelectSqlGenerator.toJoin(searcher));
        sqlBuilder.append((CharSequence)this.getFormatWhere(searcher));
        return sqlBuilder.toString();
    }

    @Override
    public String generateManyToManySelectSql(String middleTable, String joinColumn, String conditionColumn, Serializable conditionColumnValue, Class<?> modelType) {
        if (StringUtils.isEmpty((Object)middleTable)) {
            throw new IllegalArgumentException("middleTable cannot be empty");
        }
        if (StringUtils.isEmpty((Object)joinColumn)) {
            throw new IllegalArgumentException("joinColumn cannot be empty");
        }
        if (StringUtils.isEmpty((Object)conditionColumn)) {
            throw new IllegalArgumentException("conditionColumn cannot be empty");
        }
        if (StringUtils.isEmpty((Object)conditionColumnValue)) {
            throw new IllegalArgumentException("conditionColumnValue cannot be empty");
        }
        if (modelType == null) {
            throw new IllegalArgumentException("modelType cannot be null");
        }
        EntityInfo entityInfo = UniversalCrudContent.getEntityInfo(modelType);
        String table = entityInfo.getTableName();
        String primaryKey = entityInfo.getPrimaryKey().getColumnName();
        String alias = table + "_01";
        String middleTableAlias = middleTable + "_01";
        StringBuilder sqlBuilder = new StringBuilder("SELECT ");
        sqlBuilder.append("`" + alias + "`.* ");
        sqlBuilder.append("FROM `" + table + "` AS `" + alias + "` ");
        sqlBuilder.append("LEFT JOIN `" + middleTable + "` as `" + middleTableAlias + "` ");
        sqlBuilder.append("ON `" + alias + "`.`" + primaryKey + "` = `" + middleTableAlias + "`.`" + joinColumn + "` ");
        if (conditionColumnValue instanceof String) {
            conditionColumnValue = super.escape((String)conditionColumnValue);
            conditionColumnValue = super.getQuotation() + conditionColumnValue + super.getQuotation();
        }
        sqlBuilder.append("WHERE `" + middleTableAlias + "`.`" + conditionColumn + "` = " + conditionColumnValue);
        return sqlBuilder.toString();
    }

    private static StringBuilder toJoin(BaseQuery searcher) {
        StringBuilder joinBuffer = new StringBuilder();
        QueryInfo queryInfo = UniversalCrudContent.getQueryInfo(searcher.getClass());
        List<QueryInfo.QueryFieldInfo> baseQueryFieldInfos = queryInfo.getBaseQueryFieldInfos();
        for (QueryInfo.QueryFieldInfo queryFieldInfo : baseQueryFieldInfos) {
            Field field = queryFieldInfo.getField();
            BaseQuery member = (BaseQuery)ReflectionUtils.getFieldValue((Object)searcher, (Field)field);
            if (member == null) continue;
            String principalColumn = queryFieldInfo.getPrincipalColumn();
            String subordinateColumn = queryFieldInfo.getSubordinateColumn();
            String joinTable = MysqlSelectSqlGenerator.getTable(field.getType());
            String joinTableAlias = member.getAlias();
            String joinStr = "LEFT";
            BaseQuery.JoinType joinType = member.getJoinType();
            if (joinType.equals((Object)BaseQuery.JoinType.RightJoin)) {
                joinStr = "RIGHT";
            } else if (joinType.equals((Object)BaseQuery.JoinType.FullJoin)) {
                joinStr = "FULL";
            } else if (joinType.equals((Object)BaseQuery.JoinType.InnerJoin)) {
                joinStr = "INNER";
            } else if (joinType.equals((Object)BaseQuery.JoinType.CrossJoin)) {
                joinStr = "CROSS";
            }
            joinBuffer.append(joinStr + " JOIN `" + joinTable + "` AS `" + joinTableAlias + "` ON ");
            joinBuffer.append("`" + joinTableAlias + "`.`" + subordinateColumn + "` = ");
            joinBuffer.append("`" + searcher.getAlias() + "`.`" + principalColumn + "` ");
            joinBuffer.append((CharSequence)MysqlSelectSqlGenerator.toJoin(member));
        }
        return joinBuffer;
    }

    private static StringBuilder toOrder(BaseQuery baseQuery) {
        StringBuilder result = new StringBuilder();
        String strOrder = baseQuery.getOrder();
        if (strOrder != null) {
            String[] orders = strOrder.split(",");
            for (int i = 0; i < orders.length; ++i) {
                String[] parts = orders[i].split(" ");
                String fieldName = parts[0];
                String orderName = MysqlSelectSqlGenerator.getOrderMember(baseQuery, fieldName);
                if (orderName == null) {
                    throw new IllegalArgumentException(baseQuery.getClass().getName() + "\u7c7b\u67e5\u8be2\u5bf9\u8c61\u91cc\u6ca1\u6709\u4e0e'" + fieldName + "'\u5bf9\u5e94\u7684\u5b57\u6bb5,\u5982\u679c\u8fd9\u662f\u4e00\u4e2a\u6df1\u5c42\u6b21\u6392\u5e8f\uff0c\u8fd9\u53ef\u80fd\u662f\u5173\u8054\u67e5\u8be2\u5bf9\u8c61\u672a\u8d4b\u503c\u5f15\u8d77\u7684");
                }
                result.append(orderName + " " + parts[1] + ", ");
            }
        }
        if (result.indexOf(", ") != -1) {
            result.delete(result.length() - 2, result.length());
            result.insert(0, "ORDER BY ");
        }
        result.append(" ");
        return result;
    }

    private static String getOrderMember(BaseQuery searcher, String fieldName) {
        String[] fieldNames = fieldName.split("\\.");
        QueryInfo queryInfo = UniversalCrudContent.getQueryInfo(searcher.getClass());
        List<QueryInfo.QueryFieldInfo> queryFieldInfos = queryInfo.getQueryFieldInfos();
        for (QueryInfo.QueryFieldInfo queryFieldInfo : queryFieldInfos) {
            Field searcherField = queryFieldInfo.getField();
            if (fieldNames.length == 1) {
                if (!searcherField.getName().equals(fieldName)) continue;
                if (!BaseParam.class.isAssignableFrom(searcherField.getType())) break;
                String orderName = "`" + searcher.getAlias() + "`.`" + queryFieldInfo.getColumnName() + "`";
                return orderName;
            }
            if (!searcherField.getName().equals(fieldNames[0])) continue;
            if (BaseQuery.class.isAssignableFrom(searcherField.getType())) {
                BaseQuery sonSearcher = (BaseQuery)ReflectionUtils.getFieldValue((Object)searcher, (Field)searcherField);
                if (sonSearcher == null) continue;
                return MysqlSelectSqlGenerator.getOrderMember(sonSearcher, fieldName.substring(fieldName.indexOf(".") + 1));
            }
            throw new IllegalArgumentException("\u6df1\u5c42\u6b21\u6392\u5e8f\u5fc5\u987b\u6307\u5b9a\u5728\u8fde\u63a5\u67e5\u8be2\u4e0a");
        }
        return null;
    }

    private static String toLimit(BaseQuery baseQuery) {
        if (baseQuery.getLimit() != null) {
            return "LIMIT " + baseQuery.getLimit().getStartRow() + "," + baseQuery.getLimit().getPageSize() + " ";
        }
        return " ";
    }

    private LinkedList<String> toWhere(BaseQuery searcher) {
        LinkedList<String> result = new LinkedList<String>();
        QueryInfo queryInfo = UniversalCrudContent.getQueryInfo(searcher.getClass());
        List<QueryInfo.QueryFieldInfo> queryFieldInfos = queryInfo.getQueryFieldInfos();
        for (QueryInfo.QueryFieldInfo queryFieldInfo : queryFieldInfos) {
            Field field = queryFieldInfo.getField();
            String columnName = queryFieldInfo.getColumnName();
            Object member = ReflectionUtils.getFieldValue((Object)searcher, (Field)field);
            if (member == null) continue;
            if (BaseParam.class.isAssignableFrom(field.getType())) {
                BaseParam baseMember = (BaseParam)member;
                if (baseMember.isEmpty()) continue;
                result.add(baseMember.getCondition() + " `" + searcher.getAlias() + "`.`" + columnName + "` " + this.paramToSqlPart(baseMember) + " ");
                continue;
            }
            if (!field.getType().isAnnotationPresent(Query.class)) continue;
            result.addAll(this.toWhere((BaseQuery)member));
        }
        return result;
    }

    private StringBuilder getFormatWhere(BaseQuery searcher) {
        LinkedList<String> wheres = this.toWhere(searcher);
        Collections.sort(wheres, new Comparator<String>(){

            @Override
            public int compare(String str1, String str2) {
                return str1.trim().compareToIgnoreCase(str2.trim());
            }
        });
        StringBuilder resultBuffer = new StringBuilder();
        for (String where : wheres) {
            resultBuffer.append(where);
        }
        if (resultBuffer.indexOf("AND") != -1 || resultBuffer.indexOf("OR") != -1) {
            resultBuffer.delete(0, resultBuffer.indexOf(" "));
            resultBuffer.insert(0, "WHERE");
        }
        return resultBuffer;
    }

    private static String getPrimaryKeyName(Class<?> modelType) {
        return UniversalCrudContent.getEntityInfo(modelType).getPrimaryKey().getColumnName();
    }

    private static Class<?> getModelType(Class<?> queryType) {
        if (queryType == null) {
            throw new IllegalArgumentException("queryType cant not be null");
        }
        QueryInfo queryInfo = UniversalCrudContent.getQueryInfo(queryType);
        Class<?> modelType = queryInfo.getQueryEntityCalss();
        return modelType;
    }

    private static String getTable(Class<?> queryType) {
        QueryInfo queryInfo = UniversalCrudContent.getQueryInfo(queryType);
        Class<?> modelType = queryInfo.getQueryEntityCalss();
        return UniversalCrudContent.getEntityInfo(modelType).getTableName();
    }

    private String paramToSqlPart(BaseParam<? extends Serializable> param) {
        if (StringParam.class.isAssignableFrom(param.getClass())) {
            return this.stringParamToSqlPart((StringParam)param);
        }
        if (DateParam.class.isAssignableFrom(param.getClass())) {
            return this.dateParamToSqlPart((DateParam)param);
        }
        if (NumberParam.class.isAssignableFrom(param.getClass())) {
            return this.numberParamToSqlPart((NumberParam)param);
        }
        if (BooleanParam.class.isAssignableFrom(param.getClass())) {
            return this.booleanParamToSqlPart((BooleanParam)param);
        }
        return " ";
    }

    private String stringParamToSqlPart(StringParam param) {
        if (param == null || param.isEmpty()) {
            return " ";
        }
        String escape = super.getQuotation();
        BaseParam.Operator operator = param.getOperator();
        if (BaseParam.Operator.equal.equals(operator) || BaseParam.Operator.unequal.equals(operator) || BaseParam.Operator.more.equals(operator) || BaseParam.Operator.less.equals(operator) || BaseParam.Operator.moreOrEqual.equals(operator) || BaseParam.Operator.lessOrEqual.equals(operator) || BaseParam.Operator.regexp.equals(operator)) {
            String value = param.getValue();
            value = super.escape(value);
            value = escape + value + escape;
            return operator.getOperator() + " " + value + " ";
        }
        if (BaseParam.Operator.like.equals(operator) || BaseParam.Operator.unlike.equals(operator)) {
            String value = param.getValue();
            value = super.escape(value);
            if (StringParam.Fuzzt.Left.equals((Object)param.getFuzzt())) {
                value = "%" + value;
            } else if (StringParam.Fuzzt.Right.equals((Object)param.getFuzzt())) {
                value = value + "%";
            } else if (StringParam.Fuzzt.All.equals((Object)param.getFuzzt())) {
                value = "%" + value + "%";
            }
            value = escape + value + escape;
            return operator.getOperator() + " " + value + " ";
        }
        if (BaseParam.Operator.between.equals(operator) || BaseParam.Operator.notBetween.equals(operator)) {
            String minValue = param.getMinValue();
            minValue = super.escape(minValue);
            minValue = escape + minValue + escape;
            String maxValue = param.getMaxValue();
            maxValue = super.escape(maxValue);
            maxValue = escape + maxValue + escape;
            return operator.getOperator() + " " + minValue + " AND " + maxValue + " ";
        }
        if (BaseParam.Operator.in.equals(operator) || BaseParam.Operator.notIn.equals(operator)) {
            List<String> multiValues = param.getMultiValues();
            StringBuilder stringValues = new StringBuilder();
            for (int i = 0; i < multiValues.size(); ++i) {
                String multiValue = multiValues.get(i);
                multiValue = super.escape(multiValue);
                multiValue = i + 1 == multiValues.size() ? escape + multiValue + escape : escape + multiValue + escape + ", ";
                stringValues.append(multiValue);
            }
            return operator.getOperator() + "(" + stringValues.toString() + ") ";
        }
        if (BaseParam.Operator.isNull.equals(operator) || BaseParam.Operator.isNotNull.equals(operator)) {
            return operator.getOperator() + " NULL ";
        }
        return " ";
    }

    private String dateParamToSqlPart(DateParam param) {
        SimpleDateFormat dateForma = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        StringParam stringParam = new StringParam();
        stringParam.setFuzzt(StringParam.Fuzzt.Custom);
        stringParam.setCondition(param.getCondition());
        stringParam.setOperator(param.getOperator());
        if (param.getValue() != null) {
            stringParam.setValue(dateForma.format(param.getValue()));
        } else if (param.getMinValue() != null) {
            stringParam.setMinValue(dateForma.format(param.getMinValue()));
        } else if (param.getMaxValue() != null) {
            stringParam.setMaxValue(dateForma.format(param.getMaxValue()));
        } else if (param.getMultiValues() != null) {
            LinkedList<String> multiValues = new LinkedList<String>();
            for (Date multiValue : param.getMultiValues()) {
                multiValues.add(dateForma.format(multiValue));
            }
            stringParam.setMultiValues(multiValues);
        }
        return this.stringParamToSqlPart(stringParam);
    }

    private String numberParamToSqlPart(NumberParam param) {
        if (param == null || param.isEmpty()) {
            return " ";
        }
        BaseParam.Operator operator = param.getOperator();
        if (BaseParam.Operator.equal.equals(operator) || BaseParam.Operator.unequal.equals(operator) || BaseParam.Operator.more.equals(operator) || BaseParam.Operator.less.equals(operator) || BaseParam.Operator.moreOrEqual.equals(operator) || BaseParam.Operator.lessOrEqual.equals(operator)) {
            return operator.getOperator() + " " + param.getValue() + " ";
        }
        if (BaseParam.Operator.between.equals(operator) || BaseParam.Operator.notBetween.equals(operator)) {
            return operator.getOperator() + " " + param.getMinValue() + " AND " + param.getMaxValue() + " ";
        }
        if (BaseParam.Operator.in.equals(operator) || BaseParam.Operator.notIn.equals(operator)) {
            List<Number> multiValues = param.getMultiValues();
            StringBuilder stringValues = new StringBuilder();
            for (int i = 0; i < multiValues.size(); ++i) {
                Number multiValue = multiValues.get(i);
                if (i + 1 == multiValues.size()) {
                    stringValues.append(multiValue);
                    continue;
                }
                stringValues.append(multiValue + ", ");
            }
            return operator.getOperator() + "(" + stringValues.toString() + ") ";
        }
        if (BaseParam.Operator.isNull.equals(operator) || BaseParam.Operator.isNotNull.equals(operator)) {
            return operator.getOperator() + " NULL ";
        }
        return " ";
    }

    private String booleanParamToSqlPart(BooleanParam param) {
        NumberParam numberParam = new NumberParam();
        numberParam.setCondition(param.getCondition());
        numberParam.setOperator(param.getOperator());
        if (param.getValue() != null) {
            Integer value = param.getValue() != false ? 1 : 0;
            numberParam.setValue(value);
        } else if (param.getMinValue() != null) {
            Integer minValue = param.getMinValue() != false ? 1 : 0;
            numberParam.setMinValue(minValue);
        } else if (param.getMaxValue() != null) {
            Integer maxValue = param.getMaxValue() != false ? 1 : 0;
            numberParam.setMaxValue(maxValue);
        } else if (param.getMultiValues() != null) {
            LinkedList<Number> multiValues = new LinkedList<Number>();
            for (Boolean multiValue : param.getMultiValues()) {
                Integer value = multiValue != false ? 1 : 0;
                multiValues.add(value);
            }
            numberParam.setMultiValues(multiValues);
        }
        return this.numberParamToSqlPart(numberParam);
    }
}

