/*
 * Decompiled with CFR 0.152.
 */
package org.linuxprobe.crud.utils;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.LinkedList;
import java.util.List;
import javax.sql.rowset.serial.SerialBlob;
import org.linuxprobe.crud.core.content.UniversalCrudContent;
import org.linuxprobe.luava.reflection.ReflectionUtils;
import org.linuxprobe.luava.string.StringUtils;
import org.springframework.util.StreamUtils;

public class SqlFieldUtil {
    public static List<Class<?>> getSqlSuperClasss() {
        LinkedList result = new LinkedList();
        result.add(Byte.class);
        result.add(Character.class);
        result.add(Short.class);
        result.add(Boolean.class);
        result.add(Integer.class);
        result.add(Long.class);
        result.add(Float.class);
        result.add(Double.class);
        result.add(BigDecimal.class);
        result.add(Number.class);
        result.add(String.class);
        result.add(Enum.class);
        result.add(Blob.class);
        result.add(java.util.Date.class);
        result.add(Byte[].class);
        result.add(Byte.TYPE);
        result.add(Character.TYPE);
        result.add(Short.TYPE);
        result.add(Boolean.TYPE);
        result.add(Integer.TYPE);
        result.add(Long.TYPE);
        result.add(Float.TYPE);
        result.add(Double.TYPE);
        result.add(byte[].class);
        return result;
    }

    public static List<Field> getAllSqlSupportFields(Class<?> objClass) {
        List fields = ReflectionUtils.getAllFields(objClass);
        LinkedList<Field> result = new LinkedList<Field>();
        List<Class<?>> sqlSuperClasss = SqlFieldUtil.getSqlSuperClasss();
        block0: for (Field field : fields) {
            int modifiers = field.getModifiers();
            if (Modifier.isStatic(modifiers) && Modifier.isPrivate(modifiers) && Modifier.isFinal(modifiers) && field.getName().equals("serialVersionUID")) continue;
            for (Class<?> superClass : sqlSuperClasss) {
                if (!superClass.isAssignableFrom(field.getType())) continue;
                result.add(field);
                continue block0;
            }
        }
        return result;
    }

    public static boolean isFacultyOfString(Class<?> type) {
        return String.class.isAssignableFrom(type);
    }

    public static boolean isFacultyOfDate(Class<?> type) {
        return java.util.Date.class.isAssignableFrom(type);
    }

    public static boolean isFacultyOfNumber(Class<?> type) {
        if (Number.class.isAssignableFrom(type)) {
            return true;
        }
        if (Byte.TYPE.isAssignableFrom(type)) {
            return true;
        }
        if (Short.TYPE.isAssignableFrom(type)) {
            return true;
        }
        if (Integer.TYPE.isAssignableFrom(type)) {
            return true;
        }
        if (Long.TYPE.isAssignableFrom(type)) {
            return true;
        }
        if (Float.TYPE.isAssignableFrom(type)) {
            return true;
        }
        return Double.TYPE.isAssignableFrom(type);
    }

    public static boolean isFacultyOfBlob(Class<?> type) {
        if (Blob.class.isAssignableFrom(type)) {
            return true;
        }
        if (byte[].class.isAssignableFrom(type)) {
            return true;
        }
        return Byte[].class.isAssignableFrom(type);
    }

    public static boolean isFacultyOfEnum(Class<?> type) {
        return Enum.class.isAssignableFrom(type);
    }

    public static boolean isFacultyOfBoolean(Class<?> type) {
        if (Boolean.class.isAssignableFrom(type)) {
            return true;
        }
        return Boolean.TYPE.isAssignableFrom(type);
    }

    public static boolean isFacultyOfChar(Class<?> type) {
        if (Character.TYPE.isAssignableFrom(type)) {
            return true;
        }
        return Character.class.isAssignableFrom(type);
    }

    /*
     * Unable to fully structure code
     */
    public static void setFieldValue(String column, Object entity, Object value) {
        if (value == null) {
            return;
        }
        field = null;
        entityInfo = null;
        try {
            entityInfo = UniversalCrudContent.getEntityInfo(entity.getClass());
        }
        catch (Exception var5_5) {
            // empty catch block
        }
        if (entityInfo == null) {
            try {
                field = entity.getClass().getDeclaredField(column);
                if (field != null) ** GOTO lbl19
                field = entity.getClass().getDeclaredField(StringUtils.lineToHump((String)column));
            }
            catch (NoSuchFieldException | SecurityException e) {
                throw new IllegalArgumentException(e);
            }
        } else {
            field = entityInfo.getColumnMapFieldInfo().get(column).getField();
        }
lbl19:
        // 3 sources

        if (field == null) {
            return;
        }
        if (SqlFieldUtil.isFacultyOfString(field.getType())) {
            ReflectionUtils.setFieldValue((Object)entity, (Field)field, (Object)value.toString(), (boolean)true);
        } else if (SqlFieldUtil.isFacultyOfDate(field.getType())) {
            timestamp = 0L;
            if (SqlFieldUtil.isFacultyOfDate(value.getClass())) {
                timestamp = ((java.util.Date)value).getTime();
            } else if (SqlFieldUtil.isFacultyOfNumber(value.getClass())) {
                timestamp = ((Number)value).longValue();
            } else {
                throw new ClassCastException(value.getClass().getName() + " can't cast to " + field.getType().getName());
            }
            if (Date.class.isAssignableFrom(field.getType())) {
                ReflectionUtils.setFieldValue((Object)entity, (Field)field, (Object)new Date(timestamp), (boolean)true);
            } else if (Timestamp.class.isAssignableFrom(field.getType())) {
                ReflectionUtils.setFieldValue((Object)entity, (Field)field, (Object)new Timestamp(timestamp), (boolean)true);
            } else if (Time.class.isAssignableFrom(field.getType())) {
                ReflectionUtils.setFieldValue((Object)entity, (Field)field, (Object)new Time(timestamp), (boolean)true);
            } else if (java.util.Date.class.isAssignableFrom(field.getType())) {
                ReflectionUtils.setFieldValue((Object)entity, (Field)field, (Object)new java.util.Date(timestamp), (boolean)true);
            }
        } else if (SqlFieldUtil.isFacultyOfNumber(field.getType())) {
            number = (Number)value;
            if (BigDecimal.class.isAssignableFrom(field.getType())) {
                ReflectionUtils.setFieldValue((Object)entity, (Field)field, (Object)new BigDecimal(number.toString()), (boolean)true);
            } else if (Byte.TYPE.isAssignableFrom(field.getType()) || Byte.class.isAssignableFrom(field.getType())) {
                ReflectionUtils.setFieldValue((Object)entity, (Field)field, (Object)number.byteValue(), (boolean)true);
            } else if (Short.TYPE.isAssignableFrom(field.getType()) || Short.class.isAssignableFrom(field.getType())) {
                ReflectionUtils.setFieldValue((Object)entity, (Field)field, (Object)number.shortValue(), (boolean)true);
            } else if (Integer.TYPE.isAssignableFrom(field.getType()) || Integer.class.isAssignableFrom(field.getType())) {
                ReflectionUtils.setFieldValue((Object)entity, (Field)field, (Object)number.intValue(), (boolean)true);
            } else if (Long.TYPE.isAssignableFrom(field.getType()) || Long.class.isAssignableFrom(field.getType())) {
                ReflectionUtils.setFieldValue((Object)entity, (Field)field, (Object)number.longValue(), (boolean)true);
            } else if (Float.TYPE.isAssignableFrom(field.getType()) || Float.class.isAssignableFrom(field.getType())) {
                ReflectionUtils.setFieldValue((Object)entity, (Field)field, (Object)Float.valueOf(number.floatValue()), (boolean)true);
            } else if (Double.TYPE.isAssignableFrom(field.getType()) || Double.class.isAssignableFrom(field.getType())) {
                ReflectionUtils.setFieldValue((Object)entity, (Field)field, (Object)number.doubleValue(), (boolean)true);
            }
        } else if (SqlFieldUtil.isFacultyOfBlob(field.getType())) {
            field.setAccessible(true);
            if (Blob.class.isAssignableFrom(value.getClass())) {
                blob = (Blob)value;
                if (Blob.class.isAssignableFrom(field.getType())) {
                    ReflectionUtils.setFieldValue((Object)entity, (Field)field, (Object)value, (boolean)true);
                } else if (Byte[].class.isAssignableFrom(field.getType())) {
                    try {
                        byteb = StreamUtils.copyToByteArray((InputStream)blob.getBinaryStream());
                        bin = new Byte[byteb.length];
                        for (i = 0; i < bin.length; ++i) {
                            bin[i] = byteb[i];
                        }
                        ReflectionUtils.setFieldValue((Object)entity, (Field)field, (Object)bin, (boolean)true);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException(e);
                    }
                } else if (byte[].class.isAssignableFrom(field.getType())) {
                    try {
                        ReflectionUtils.setFieldValue((Object)entity, (Field)field, (Object)StreamUtils.copyToByteArray((InputStream)blob.getBinaryStream()), (boolean)true);
                    }
                    catch (IOException | SQLException e) {
                        throw new IllegalArgumentException(e);
                    }
                }
            } else if (Byte[].class.isAssignableFrom(value.getClass())) {
                if (Byte[].class.isAssignableFrom(field.getType())) {
                    ReflectionUtils.setFieldValue((Object)entity, (Field)field, (Object)value, (boolean)true);
                } else if (byte[].class.isAssignableFrom(field.getType())) {
                    byteb = (Byte[])value;
                    bin = new byte[byteb.length];
                    for (i = 0; i < bin.length; ++i) {
                        bin[i] = byteb[i];
                    }
                    ReflectionUtils.setFieldValue((Object)entity, (Field)field, (Object)bin, (boolean)true);
                } else if (SerialBlob.class.isAssignableFrom(field.getType())) {
                    byteb = (Byte[])value;
                    bin = new byte[byteb.length];
                    for (i = 0; i < bin.length; ++i) {
                        bin[i] = byteb[i];
                    }
                    try {
                        serialBlob = new SerialBlob(bin);
                        ReflectionUtils.setFieldValue((Object)entity, (Field)field, (Object)serialBlob, (boolean)true);
                    }
                    catch (SQLException e) {
                        throw new RuntimeException(e);
                    }
                }
            } else if (byte[].class.isAssignableFrom(value.getClass())) {
                if (byte[].class.isAssignableFrom(field.getType())) {
                    ReflectionUtils.setFieldValue((Object)entity, (Field)field, (Object)value, (boolean)true);
                } else if (Byte[].class.isAssignableFrom(field.getType())) {
                    byteb = (byte[])value;
                    bin = new Byte[byteb.length];
                    for (i = 0; i < bin.length; ++i) {
                        bin[i] = byteb[i];
                    }
                    ReflectionUtils.setFieldValue((Object)entity, (Field)field, (Object)bin, (boolean)true);
                } else if (SerialBlob.class.isAssignableFrom(field.getType())) {
                    try {
                        serialBlob = new SerialBlob((byte[])value);
                        ReflectionUtils.setFieldValue((Object)entity, (Field)field, (Object)serialBlob, (boolean)true);
                    }
                    catch (SQLException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        } else if (SqlFieldUtil.isFacultyOfEnum(field.getType())) {
            enumType = field.getType();
            if (value instanceof String) {
                ReflectionUtils.setFieldValue((Object)entity, (Field)field, Enum.valueOf(enumType, (String)value), (boolean)true);
            } else if (SqlFieldUtil.isFacultyOfNumber(value.getClass())) {
                ordinal = ((Number)value).intValue();
                for (Enum tempEnum : enums = (Enum[])enumType.getEnumConstants()) {
                    if (tempEnum.ordinal() != ordinal) continue;
                    ReflectionUtils.setFieldValue((Object)entity, (Field)field, (Object)tempEnum, (boolean)true);
                    break;
                }
            }
        } else if (SqlFieldUtil.isFacultyOfBoolean(field.getType())) {
            if (value instanceof Boolean) {
                ReflectionUtils.setFieldValue((Object)entity, (Field)field, (Object)value, (boolean)true);
            } else if (Boolean.TYPE.isAssignableFrom(value.getClass())) {
                ReflectionUtils.setFieldValue((Object)entity, (Field)field, (Object)value, (boolean)true);
            } else if (value instanceof String) {
                strValue = ((String)value).toLowerCase();
                if (!(strValue.equals("yes") || strValue.equals("no") || strValue.equals("true") || strValue.equals("false"))) {
                    throw new ClassCastException("can't cast " + strValue + " to boolean");
                }
                if (strValue.equals("yes") || strValue.equals("true")) {
                    ReflectionUtils.setFieldValue((Object)entity, (Field)field, (Object)true, (boolean)true);
                } else if (strValue.equals("no") || strValue.equals("false")) {
                    ReflectionUtils.setFieldValue((Object)entity, (Field)field, (Object)false, (boolean)true);
                }
            } else if (SqlFieldUtil.isFacultyOfNumber(value.getClass())) {
                intValue = ((Number)value).intValue();
                if (intValue != 0) {
                    ReflectionUtils.setFieldValue((Object)entity, (Field)field, (Object)true, (boolean)true);
                } else {
                    ReflectionUtils.setFieldValue((Object)entity, (Field)field, (Object)false, (boolean)true);
                }
            }
        } else if (SqlFieldUtil.isFacultyOfChar(field.getType())) {
            if (value instanceof String) {
                ReflectionUtils.setFieldValue((Object)entity, (Field)field, (Object)Character.valueOf(((String)value).charAt(0)), (boolean)true);
            } else if (SqlFieldUtil.isFacultyOfNumber(value.getClass())) {
                intValue = ((Number)value).intValue();
                ReflectionUtils.setFieldValue((Object)entity, (Field)field, (Object)Character.valueOf((char)intValue), (boolean)true);
            }
        }
    }
}

