/*
 * Decompiled with CFR 0.152.
 */
package org.linuxprobe.crud.mybatis.spring;

import java.io.IOException;
import java.lang.reflect.Modifier;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Stream;
import javax.sql.DataSource;
import org.apache.ibatis.builder.xml.XMLMapperBuilder;
import org.apache.ibatis.cache.Cache;
import org.apache.ibatis.executor.ErrorContext;
import org.apache.ibatis.io.Resources;
import org.apache.ibatis.io.VFS;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.mapping.DatabaseIdProvider;
import org.apache.ibatis.mapping.Environment;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.reflection.factory.ObjectFactory;
import org.apache.ibatis.reflection.wrapper.ObjectWrapperFactory;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.transaction.TransactionFactory;
import org.apache.ibatis.type.TypeAliasRegistry;
import org.apache.ibatis.type.TypeHandler;
import org.apache.ibatis.type.TypeHandlerRegistry;
import org.linuxprobe.crud.mybatis.session.UniversalCrudConfiguration;
import org.linuxprobe.crud.mybatis.session.UniversalCrudSqlSessionFactory;
import org.linuxprobe.crud.mybatis.session.UniversalCrudSqlSessionFactoryBuilder;
import org.linuxprobe.crud.mybatis.session.builder.xml.UniversalCrudXMLConfigBuilder;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.transaction.SpringManagedTransactionFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.NestedIOException;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.type.ClassMetadata;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class UniversalCrudSqlSessionFactoryBean
implements FactoryBean<UniversalCrudSqlSessionFactory>,
ApplicationListener<ApplicationEvent> {
    private static final Log LOGGER = LogFactory.getLog(UniversalCrudSqlSessionFactoryBean.class);
    private static final ResourcePatternResolver RESOURCE_PATTERN_RESOLVER = new PathMatchingResourcePatternResolver();
    private static final MetadataReaderFactory METADATA_READER_FACTORY = new CachingMetadataReaderFactory();
    private boolean failFast;
    private DataSource dataSource;
    private Resource configLocation;
    private UniversalCrudConfiguration configuration;
    private Properties configurationProperties;
    private ObjectFactory objectFactory;
    private ObjectWrapperFactory objectWrapperFactory;
    private String typeAliasesPackage;
    private Class<?> typeAliasesSuperType;
    private Class<? extends VFS> vfs;
    private Interceptor[] plugins;
    private Class<?>[] typeAliases;
    private String typeHandlersPackage;
    private TypeHandler<?>[] typeHandlers;
    private DatabaseIdProvider databaseIdProvider;
    private Cache cache;
    private String environment = SqlSessionFactoryBean.class.getSimpleName();
    private TransactionFactory transactionFactory;
    private Resource[] mapperLocations;
    private UniversalCrudSqlSessionFactoryBuilder sqlSessionFactoryBuilder = new UniversalCrudSqlSessionFactoryBuilder();
    private UniversalCrudSqlSessionFactory sqlSessionFactory;
    private String universalCrudScan;

    private Set<Class<?>> scanClasses(String packagePatterns, Class<?> assignableType) throws IOException {
        String[] packagePatternArray;
        HashSet classes = new HashSet();
        for (String packagePattern : packagePatternArray = StringUtils.tokenizeToStringArray((String)packagePatterns, (String)",; \t\n")) {
            Resource[] resources;
            for (Resource resource : resources = RESOURCE_PATTERN_RESOLVER.getResources("classpath*:" + ClassUtils.convertClassNameToResourcePath((String)packagePattern) + "/**/*.class")) {
                try {
                    ClassMetadata classMetadata = METADATA_READER_FACTORY.getMetadataReader(resource).getClassMetadata();
                    Class clazz = Resources.classForName((String)classMetadata.getClassName());
                    if (assignableType != null && !assignableType.isAssignableFrom(clazz)) continue;
                    classes.add(clazz);
                }
                catch (Throwable e) {
                    LOGGER.warn("Cannot load the '" + resource + "'. Cause by " + e.toString());
                }
            }
        }
        return classes;
    }

    protected UniversalCrudSqlSessionFactory buildSqlSessionFactory() throws Exception {
        UniversalCrudConfiguration configuration;
        UniversalCrudXMLConfigBuilder xmlConfigBuilder = null;
        if (this.configuration != null) {
            configuration = this.configuration;
            if (configuration.getVariables() == null) {
                configuration.setVariables(this.configurationProperties);
            } else if (this.configurationProperties != null) {
                configuration.getVariables().putAll((Map<?, ?>)this.configurationProperties);
            }
        } else if (this.configLocation != null) {
            xmlConfigBuilder = new UniversalCrudXMLConfigBuilder(this.configLocation.getInputStream(), null, this.configurationProperties);
            configuration = (UniversalCrudConfiguration)xmlConfigBuilder.getConfiguration();
        } else {
            LOGGER.debug("Property 'configuration' or 'configLocation' not specified, using default MyBatis Configuration");
            configuration = new UniversalCrudConfiguration();
            Optional.ofNullable(this.configurationProperties).ifPresent(arg_0 -> ((UniversalCrudConfiguration)configuration).setVariables(arg_0));
        }
        Optional.ofNullable(this.objectFactory).ifPresent(arg_0 -> ((UniversalCrudConfiguration)configuration).setObjectFactory(arg_0));
        Optional.ofNullable(this.objectWrapperFactory).ifPresent(arg_0 -> ((UniversalCrudConfiguration)configuration).setObjectWrapperFactory(arg_0));
        Optional.ofNullable(this.vfs).ifPresent(arg_0 -> ((UniversalCrudConfiguration)configuration).setVfsImpl(arg_0));
        if (StringUtils.hasLength((String)this.typeAliasesPackage)) {
            this.scanClasses(this.typeAliasesPackage, this.typeAliasesSuperType).forEach(arg_0 -> ((TypeAliasRegistry)configuration.getTypeAliasRegistry()).registerAlias(arg_0));
        }
        if (!ObjectUtils.isEmpty((Object[])this.typeAliases)) {
            Stream.of(this.typeAliases).forEach(typeAlias -> {
                configuration.getTypeAliasRegistry().registerAlias(typeAlias);
                LOGGER.debug("Registered type alias: '" + typeAlias + "'");
            });
        }
        if (!ObjectUtils.isEmpty((Object[])this.plugins)) {
            Stream.of(this.plugins).forEach(plugin -> {
                configuration.addInterceptor((Interceptor)plugin);
                LOGGER.debug("Registered plugin: '" + plugin + "'");
            });
        }
        if (StringUtils.hasLength((String)this.typeHandlersPackage)) {
            this.scanClasses(this.typeHandlersPackage, TypeHandler.class).stream().filter(clazz -> !clazz.isInterface()).filter(clazz -> !Modifier.isAbstract(clazz.getModifiers())).filter(clazz -> ClassUtils.getConstructorIfAvailable((Class)clazz, (Class[])new Class[0]) != null).forEach(arg_0 -> ((TypeHandlerRegistry)configuration.getTypeHandlerRegistry()).register(arg_0));
        }
        if (!ObjectUtils.isEmpty((Object[])this.typeHandlers)) {
            Stream.of(this.typeHandlers).forEach(typeHandler -> {
                configuration.getTypeHandlerRegistry().register(typeHandler);
                LOGGER.debug("Registered type handler: '" + typeHandler + "'");
            });
        }
        if (this.databaseIdProvider != null) {
            try {
                configuration.setDatabaseId(this.databaseIdProvider.getDatabaseId(this.dataSource));
            }
            catch (SQLException e) {
                throw new NestedIOException("Failed getting a databaseId", (Throwable)e);
            }
        }
        Optional.ofNullable(this.cache).ifPresent(arg_0 -> ((UniversalCrudConfiguration)configuration).addCache(arg_0));
        if (xmlConfigBuilder != null) {
            try {
                xmlConfigBuilder.parse();
                LOGGER.debug("Parsed configuration file: '" + this.configLocation + "'");
            }
            catch (Exception ex) {
                throw new NestedIOException("Failed to parse config resource: " + this.configLocation, (Throwable)ex);
            }
            finally {
                ErrorContext.instance().reset();
            }
        }
        configuration.setEnvironment(new Environment(this.environment, (TransactionFactory)(this.transactionFactory == null ? new SpringManagedTransactionFactory() : this.transactionFactory), this.dataSource));
        if (this.mapperLocations != null) {
            if (this.mapperLocations.length == 0) {
                LOGGER.warn("Property 'mapperLocations' was specified but matching resources are not found.");
            } else {
                for (Resource mapperLocation : this.mapperLocations) {
                    if (mapperLocation == null) continue;
                    try {
                        XMLMapperBuilder xmlMapperBuilder = new XMLMapperBuilder(mapperLocation.getInputStream(), (Configuration)configuration, mapperLocation.toString(), configuration.getSqlFragments());
                        xmlMapperBuilder.parse();
                    }
                    catch (Exception e) {
                        throw new NestedIOException("Failed to parse mapping resource: '" + mapperLocation + "'", (Throwable)e);
                    }
                    finally {
                        ErrorContext.instance().reset();
                    }
                    LOGGER.debug("Parsed mapper file: '" + mapperLocation + "'");
                }
            }
        } else {
            LOGGER.debug("Property 'mapperLocations' was not specified.");
        }
        configuration.setUniversalCrudScan(this.universalCrudScan);
        return this.sqlSessionFactoryBuilder.build(configuration);
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.universalCrudScan, (String)"Property 'universalCrudScan' is required");
        Assert.notNull((Object)this.dataSource, (String)"Property 'dataSource' is required");
        Assert.notNull((Object)this.sqlSessionFactoryBuilder, (String)"Property 'sqlSessionFactoryBuilder' is required");
        Assert.state((this.configuration == null && this.configLocation == null || this.configuration == null || this.configLocation == null ? 1 : 0) != 0, (String)"Property 'configuration' and 'configLocation' can not specified with together");
        this.sqlSessionFactory = this.buildSqlSessionFactory();
    }

    public UniversalCrudSqlSessionFactory getObject() throws Exception {
        if (this.sqlSessionFactory == null) {
            this.afterPropertiesSet();
        }
        return this.sqlSessionFactory;
    }

    public Class<?> getObjectType() {
        return this.sqlSessionFactory == null ? UniversalCrudSqlSessionFactory.class : this.sqlSessionFactory.getClass();
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (this.failFast && event instanceof ContextRefreshedEvent) {
            this.sqlSessionFactory.getConfiguration().getMappedStatementNames();
        }
    }

    public boolean isFailFast() {
        return this.failFast;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public Resource getConfigLocation() {
        return this.configLocation;
    }

    public UniversalCrudConfiguration getConfiguration() {
        return this.configuration;
    }

    public Properties getConfigurationProperties() {
        return this.configurationProperties;
    }

    public ObjectFactory getObjectFactory() {
        return this.objectFactory;
    }

    public ObjectWrapperFactory getObjectWrapperFactory() {
        return this.objectWrapperFactory;
    }

    public String getTypeAliasesPackage() {
        return this.typeAliasesPackage;
    }

    public Class<?> getTypeAliasesSuperType() {
        return this.typeAliasesSuperType;
    }

    public Class<? extends VFS> getVfs() {
        return this.vfs;
    }

    public Interceptor[] getPlugins() {
        return this.plugins;
    }

    public Class<?>[] getTypeAliases() {
        return this.typeAliases;
    }

    public String getTypeHandlersPackage() {
        return this.typeHandlersPackage;
    }

    public TypeHandler<?>[] getTypeHandlers() {
        return this.typeHandlers;
    }

    public DatabaseIdProvider getDatabaseIdProvider() {
        return this.databaseIdProvider;
    }

    public Cache getCache() {
        return this.cache;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public TransactionFactory getTransactionFactory() {
        return this.transactionFactory;
    }

    public Resource[] getMapperLocations() {
        return this.mapperLocations;
    }

    public UniversalCrudSqlSessionFactoryBuilder getSqlSessionFactoryBuilder() {
        return this.sqlSessionFactoryBuilder;
    }

    public UniversalCrudSqlSessionFactory getSqlSessionFactory() {
        return this.sqlSessionFactory;
    }

    public String getUniversalCrudScan() {
        return this.universalCrudScan;
    }

    public void setFailFast(boolean failFast) {
        this.failFast = failFast;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setConfigLocation(Resource configLocation) {
        this.configLocation = configLocation;
    }

    public void setConfiguration(UniversalCrudConfiguration configuration) {
        this.configuration = configuration;
    }

    public void setConfigurationProperties(Properties configurationProperties) {
        this.configurationProperties = configurationProperties;
    }

    public void setObjectFactory(ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    public void setObjectWrapperFactory(ObjectWrapperFactory objectWrapperFactory) {
        this.objectWrapperFactory = objectWrapperFactory;
    }

    public void setTypeAliasesPackage(String typeAliasesPackage) {
        this.typeAliasesPackage = typeAliasesPackage;
    }

    public void setTypeAliasesSuperType(Class<?> typeAliasesSuperType) {
        this.typeAliasesSuperType = typeAliasesSuperType;
    }

    public void setVfs(Class<? extends VFS> vfs) {
        this.vfs = vfs;
    }

    public void setPlugins(Interceptor[] plugins) {
        this.plugins = plugins;
    }

    public void setTypeAliases(Class<?>[] typeAliases) {
        this.typeAliases = typeAliases;
    }

    public void setTypeHandlersPackage(String typeHandlersPackage) {
        this.typeHandlersPackage = typeHandlersPackage;
    }

    public void setTypeHandlers(TypeHandler<?>[] typeHandlers) {
        this.typeHandlers = typeHandlers;
    }

    public void setDatabaseIdProvider(DatabaseIdProvider databaseIdProvider) {
        this.databaseIdProvider = databaseIdProvider;
    }

    public void setCache(Cache cache) {
        this.cache = cache;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public void setTransactionFactory(TransactionFactory transactionFactory) {
        this.transactionFactory = transactionFactory;
    }

    public void setMapperLocations(Resource[] mapperLocations) {
        this.mapperLocations = mapperLocations;
    }

    public void setSqlSessionFactoryBuilder(UniversalCrudSqlSessionFactoryBuilder sqlSessionFactoryBuilder) {
        this.sqlSessionFactoryBuilder = sqlSessionFactoryBuilder;
    }

    public void setSqlSessionFactory(UniversalCrudSqlSessionFactory sqlSessionFactory) {
        this.sqlSessionFactory = sqlSessionFactory;
    }

    public void setUniversalCrudScan(String universalCrudScan) {
        this.universalCrudScan = universalCrudScan;
    }
}

