/*
 * Decompiled with CFR 0.152.
 */
package org.linuxprobe.crud.core.content;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.linuxprobe.crud.core.annoatation.Column;
import org.linuxprobe.crud.core.annoatation.Entity;
import org.linuxprobe.crud.core.annoatation.PrimaryKey;
import org.linuxprobe.crud.core.annoatation.Table;
import org.linuxprobe.crud.core.annoatation.Transient;
import org.linuxprobe.crud.utils.SqlFieldUtil;
import org.linuxprobe.luava.string.StringUtils;

public class EntityInfo {
    private Class<?> entityType;
    private String tableName;
    private List<FieldInfo> fieldInfos;
    private Map<String, FieldInfo> columnMapFieldInfo = new HashMap<String, FieldInfo>();
    private FieldInfo primaryKey;

    public EntityInfo(Class<?> entityType) {
        Table table;
        if (entityType == null) {
            throw new IllegalArgumentException("entityType can't be null");
        }
        if (!entityType.isAnnotationPresent(Entity.class)) {
            throw new IllegalArgumentException(entityType.getName() + " does not have callout org.linuxprobe.crud.core.annoatation.Entity annotation");
        }
        this.entityType = entityType;
        this.tableName = StringUtils.humpToLine((String)entityType.getSimpleName());
        if (entityType.isAnnotationPresent(Table.class) && !(table = entityType.getAnnotation(Table.class)).value().isEmpty()) {
            this.tableName = table.value();
        }
        this.fieldInfos = new LinkedList<FieldInfo>();
        List<Field> fields = SqlFieldUtil.getAllSqlSupportFields(entityType);
        if (null != fields && !fields.isEmpty()) {
            for (Field field : fields) {
                Column column;
                if (field.isAnnotationPresent(Transient.class)) continue;
                String fieldName = field.getName();
                String filedColumn = StringUtils.humpToLine((String)fieldName);
                if (field.isAnnotationPresent(Column.class) && !(column = field.getAnnotation(Column.class)).value().isEmpty()) {
                    filedColumn = column.value();
                }
                FieldInfo fieldInfo = null;
                if (field.isAnnotationPresent(PrimaryKey.class)) {
                    this.primaryKey = fieldInfo = new FieldInfo(field, filedColumn, field.getAnnotation(PrimaryKey.class));
                } else {
                    fieldInfo = new FieldInfo(field, filedColumn);
                }
                this.fieldInfos.add(fieldInfo);
                this.columnMapFieldInfo.put(fieldInfo.getColumnName(), fieldInfo);
            }
        }
    }

    public boolean hasColumn(String column) {
        if (this.fieldInfos == null || this.fieldInfos.isEmpty()) {
            return false;
        }
        for (FieldInfo fieldInfo : this.fieldInfos) {
            if (!fieldInfo.getColumnName().equals(column)) continue;
            return true;
        }
        return false;
    }

    public boolean hasField(String field) {
        if (this.fieldInfos == null || this.fieldInfos.isEmpty()) {
            return false;
        }
        for (FieldInfo fieldInfo : this.fieldInfos) {
            if (!fieldInfo.getField().getName().equals(field)) continue;
            return true;
        }
        return false;
    }

    public Class<?> getEntityType() {
        return this.entityType;
    }

    public String getTableName() {
        return this.tableName;
    }

    public List<FieldInfo> getFieldInfos() {
        return this.fieldInfos;
    }

    public Map<String, FieldInfo> getColumnMapFieldInfo() {
        return this.columnMapFieldInfo;
    }

    public FieldInfo getPrimaryKey() {
        return this.primaryKey;
    }

    public static class FieldInfo {
        private Field field;
        private String columnName;
        private boolean isPrimaryKey = false;
        private PrimaryKey primaryKey;

        public FieldInfo(Field field, String columnName, PrimaryKey primaryKey) {
            this.field = field;
            this.columnName = columnName;
            if (primaryKey != null) {
                this.primaryKey = primaryKey;
                this.isPrimaryKey = true;
            }
        }

        public FieldInfo(Field field, String filedColumn) {
            this(field, filedColumn, null);
        }

        public Field getField() {
            return this.field;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public boolean isPrimaryKey() {
            return this.isPrimaryKey;
        }

        public PrimaryKey getPrimaryKey() {
            return this.primaryKey;
        }
    }
}

