/*
 * Decompiled with CFR 0.152.
 */
package org.linuxprobe.crud.core.validation;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.constraints.Size;
import javax.validation.groups.Default;
import org.hibernate.validator.HibernateValidator;
import org.hibernate.validator.HibernateValidatorConfiguration;
import org.linuxprobe.crud.utils.FieldUtil;
import org.linuxprobe.crud.utils.SqlFieldUtil;
import org.springframework.util.StreamUtils;

public class FieldValidation {
    private static ValidatorFactory validatorFactory = ((HibernateValidatorConfiguration)Validation.byProvider(HibernateValidator.class).configure()).buildValidatorFactory();
    private static Validator validator = validatorFactory.getValidator();

    public static <T> void validation(T object) {
        Set results = validator.validate(object, new Class[]{Default.class});
        if (results != null && !results.isEmpty()) {
            StringBuilder messageBuilder = new StringBuilder("in " + object.getClass().getName() + " class,");
            for (ConstraintViolation result : results) {
                messageBuilder.append(result.getPropertyPath().toString() + " " + result.getMessage() + ";");
            }
            throw new ValidationException(messageBuilder.toString());
        }
    }

    private static <T> void validationField(T object, Field field) {
        Set results = validator.validateProperty(object, field.getName(), new Class[]{Default.class});
        if (results != null && !results.isEmpty()) {
            StringBuilder messageBuilder = new StringBuilder("in " + object.getClass().getName() + " class,");
            for (ConstraintViolation result : results) {
                messageBuilder.append(result.getPropertyPath().toString() + " " + result.getMessage() + ";");
            }
            throw new ValidationException(messageBuilder.toString());
        }
    }

    private static void blobValidation(Object record, Field field) {
        Object fieldValue = FieldUtil.getFieldValue(record, field);
        if (fieldValue != null) {
            byte[] bin = null;
            if (Blob.class.isAssignableFrom(field.getType())) {
                Blob blob = (Blob)fieldValue;
                try {
                    bin = StreamUtils.copyToByteArray((InputStream)blob.getBinaryStream());
                }
                catch (IOException | SQLException e) {
                    throw new IllegalArgumentException(e);
                }
            } else if (byte[].class.isAssignableFrom(field.getType())) {
                bin = (byte[])fieldValue;
            } else if (Byte[].class.isAssignableFrom(field.getType())) {
                Byte[] binB = (Byte[])fieldValue;
                bin = new byte[binB.length];
                for (int i = 0; i < binB.length; ++i) {
                    bin[i] = binB[i];
                }
            }
            if (field.isAnnotationPresent(Size.class)) {
                Size size = field.getAnnotation(Size.class);
                if (size.min() != 0 && bin.length < size.min()) {
                    throw new ValidationException("in " + record.getClass().getName() + " class," + field.getName() + " minSize is " + size.min());
                }
                if (size.max() != 0 && bin.length > size.max()) {
                    throw new ValidationException("in " + record.getClass().getName() + " class," + field.getName() + " maxSize is " + size.max());
                }
            }
        }
    }

    public static void universalValidation(Object entity, Field field) {
        FieldValidation.validationField(entity, field);
        if (SqlFieldUtil.isFacultyOfBlob(field.getType())) {
            FieldValidation.blobValidation(entity, field);
        }
    }

    public static void universalValidation(Object entity) {
        FieldValidation.validation(entity);
    }
}

