/*
 * Decompiled with CFR 0.152.
 */
package org.linuxprobe.crud.core.proxy;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.NavigableSet;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeSet;
import java.util.Vector;
import org.linuxprobe.crud.core.annoatation.ManyToMany;
import org.linuxprobe.crud.core.annoatation.OneToMany;
import org.linuxprobe.crud.core.annoatation.OneToOne;
import org.linuxprobe.crud.core.content.EntityInfo;
import org.linuxprobe.crud.core.content.UniversalCrudContent;
import org.linuxprobe.crud.mybatis.session.SqlSessionExtend;
import org.linuxprobe.crud.utils.FieldUtil;
import org.linuxprobe.crud.utils.StringHumpTool;
import org.springframework.beans.BeanUtils;
import org.springframework.cglib.proxy.Callback;
import org.springframework.cglib.proxy.Enhancer;
import org.springframework.cglib.proxy.MethodInterceptor;
import org.springframework.cglib.proxy.MethodProxy;

public class ModelCglib
implements MethodInterceptor {
    private SqlSessionExtend sqlSessionExtend;
    private Object instance;
    private Set<String> handledMethod = new HashSet<String>();

    public ModelCglib(SqlSessionExtend sqlSessionExtend) {
        this.sqlSessionExtend = sqlSessionExtend;
    }

    public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
        Object result = proxy.invokeSuper(obj, args);
        if (result != null) {
            return result;
        }
        if (this.handledMethod.contains(method.getName())) {
            return result;
        }
        if (method.getName().startsWith("set")) {
            this.handledMethod.add(method.getName().replace("set", "get"));
            return result;
        }
        if (method.getName().startsWith("get")) {
            Field field = FieldUtil.getFieldByMethod(obj.getClass(), method);
            if (field.isAnnotationPresent(OneToOne.class)) {
                this.handledMethod.add(method.getName());
                this.handldeOneToOne(obj, field);
                return method.invoke(obj, new Object[0]);
            }
            if (field.isAnnotationPresent(OneToMany.class)) {
                this.handledMethod.add(method.getName());
                this.handldeOneToMany(obj, field);
                return method.invoke(obj, new Object[0]);
            }
            if (field.isAnnotationPresent(ManyToMany.class)) {
                this.handledMethod.add(method.getName());
                this.handldeManyToMany(obj, field);
                return method.invoke(obj, new Object[0]);
            }
            return result;
        }
        return result;
    }

    private Object handldeOneToOne(Object obj, Field field) throws Exception {
        EntityInfo.FieldInfo correlationFieldInfo;
        String columnName = StringHumpTool.humpToLine2(field.getName(), "_") + "_id";
        if (!field.getAnnotation(OneToOne.class).value().isEmpty()) {
            columnName = field.getAnnotation(OneToOne.class).value();
        }
        if ((correlationFieldInfo = UniversalCrudContent.getEntityInfo(obj.getClass()).getColumnMapFieldInfo().get(columnName)) == null) {
            throw new IllegalArgumentException(columnName + " column does not have a corresponding field.");
        }
        Serializable correlationFieldValue = (Serializable)FieldUtil.getFieldValue(obj, correlationFieldInfo.getField());
        if (correlationFieldValue != null) {
            Object result = this.sqlSessionExtend.selectByPrimaryKey(correlationFieldValue, field.getType());
            FieldUtil.setField(obj, field, result);
            return result;
        }
        return null;
    }

    private Object handldeOneToMany(Object obj, Field field) throws Exception {
        if (!Collection.class.isAssignableFrom(field.getType())) {
            throw new IllegalArgumentException("in " + obj.getClass().getName() + " " + field.getType().getName() + " must be a subclass of " + Collection.class.getName());
        }
        Field principalField = UniversalCrudContent.getEntityInfo(obj.getClass()).getPrimaryKey().getField();
        String subordinateColumn = UniversalCrudContent.getEntityInfo(obj.getClass()).getTableName() + "_id";
        OneToMany oneToMany = field.getAnnotation(OneToMany.class);
        EntityInfo entityInfo = UniversalCrudContent.getEntityInfo(obj.getClass());
        if (!"".equals(oneToMany.value())) {
            principalField = entityInfo.getColumnMapFieldInfo().get(oneToMany.value()).getField();
        } else if (!"".equals(oneToMany.principal())) {
            principalField = entityInfo.getColumnMapFieldInfo().get(oneToMany.principal()).getField();
        }
        if (!"".equals(oneToMany.subordinate())) {
            subordinateColumn = oneToMany.subordinate();
        }
        Class<?> subordinateClass = FieldUtil.getFiledGenericclass(field, 0);
        Serializable principalFieldValue = (Serializable)FieldUtil.getFieldValue(obj, principalField);
        if (principalFieldValue == null) {
            return null;
        }
        List<Object> daoResults = this.sqlSessionExtend.selectByColumn(subordinateColumn, principalFieldValue, subordinateClass);
        Collection<?> result = this.resultConvert(daoResults, field);
        FieldUtil.setField(obj, field, result);
        return result;
    }

    private Object handldeManyToMany(Object obj, Field field) throws Exception {
        if (!Collection.class.isAssignableFrom(field.getType())) {
            throw new IllegalArgumentException("in " + obj.getClass().getName() + " " + field.getType().getName() + " must be a subclass of " + Collection.class.getName());
        }
        EntityInfo entityInfo = UniversalCrudContent.getEntityInfo(obj.getClass());
        String currentTable = entityInfo.getTableName();
        Serializable primaryKey = (Serializable)FieldUtil.getFieldValue(obj, entityInfo.getPrimaryKey().getField());
        Class<?> needSelectModelType = FieldUtil.getFiledGenericclass(field, 0);
        EntityInfo needSelectEntityInfo = UniversalCrudContent.getEntityInfo(needSelectModelType);
        String needSelectTable = needSelectEntityInfo.getTableName();
        String middleTable = currentTable + "_" + needSelectTable;
        String joinColumn = needSelectTable + "_id";
        String conditionColumn = entityInfo.getTableName() + "_id";
        ManyToMany manyToMany = field.getAnnotation(ManyToMany.class);
        if (!manyToMany.middleTable().isEmpty()) {
            middleTable = manyToMany.middleTable();
        }
        if (!manyToMany.joinColumn().isEmpty()) {
            joinColumn = manyToMany.joinColumn();
        }
        if (!manyToMany.conditionColumn().isEmpty()) {
            conditionColumn = manyToMany.conditionColumn();
        }
        String sql = UniversalCrudContent.getSelectSqlGenerator().generateManyToManySelectSql(middleTable, joinColumn, conditionColumn, primaryKey, needSelectModelType);
        List<Object> datas = this.sqlSessionExtend.selectBySql(sql, needSelectModelType);
        Collection<?> result = this.resultConvert(datas, field);
        FieldUtil.setField(obj, field, result);
        return result;
    }

    private Collection<?> resultConvert(List<Object> datas, Field field) {
        Collection<Object> result = datas;
        if (!Collection.class.isAssignableFrom(field.getType())) {
            throw new IllegalArgumentException(field.getType() + "\u662f\u4e0d\u88ab\u652f\u6301\u7684\u7c7b\u578b");
        }
        if (ArrayList.class.isAssignableFrom(field.getType())) {
            result = new ArrayList<Object>(datas);
        } else if (LinkedList.class.isAssignableFrom(field.getType())) {
            result = new LinkedList<Object>(datas);
        } else if (Stack.class.isAssignableFrom(field.getType())) {
            Stack<Object> stack = new Stack<Object>();
            stack.addAll(datas);
            result = stack;
        } else if (Vector.class.isAssignableFrom(field.getType())) {
            Vector<Object> vector = new Vector<Object>();
            vector.addAll(datas);
            result = vector;
        } else if (List.class.isAssignableFrom(field.getType())) {
            result = new LinkedList<Object>(datas);
        } else if (LinkedHashSet.class.isAssignableFrom(field.getType())) {
            result = new LinkedHashSet<Object>(datas);
        } else if (HashSet.class.isAssignableFrom(field.getType())) {
            result = new HashSet<Object>(datas);
        } else if (TreeSet.class.isAssignableFrom(field.getType())) {
            result = new TreeSet<Object>(datas);
        } else if (NavigableSet.class.isAssignableFrom(field.getType())) {
            result = new TreeSet<Object>(datas);
        } else if (SortedSet.class.isAssignableFrom(field.getType())) {
            result = new TreeSet<Object>(datas);
        } else if (Set.class.isAssignableFrom(field.getType())) {
            result = new HashSet<Object>(datas);
        } else if (Queue.class.isAssignableFrom(field.getType())) {
            PriorityQueue<Object> priorityQueue = new PriorityQueue<Object>();
            priorityQueue.addAll(datas);
            result = priorityQueue;
        } else if (Deque.class.isAssignableFrom(field.getType())) {
            ArrayDeque<Object> arrayDeque = new ArrayDeque<Object>();
            arrayDeque.addAll(datas);
            result = arrayDeque;
        }
        return result;
    }

    public <T> T getInstance(Class<T> entityType) {
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(entityType);
        enhancer.setCallback((Callback)this);
        this.instance = enhancer.create();
        return (T)this.instance;
    }

    public void copy(Object source) {
        BeanUtils.copyProperties((Object)source, (Object)this.instance);
        this.handledMethod.clear();
    }

    public void clearMark() {
        this.handledMethod.clear();
    }
}

