/*
 * Decompiled with CFR 0.152.
 */
package org.linuxprobe.crud.utils;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.LinkedList;
import java.util.List;
import javax.sql.rowset.serial.SerialBlob;
import org.linuxprobe.crud.core.content.EntityInfo;
import org.linuxprobe.crud.core.content.UniversalCrudContent;
import org.linuxprobe.crud.utils.FieldUtil;
import org.springframework.util.StreamUtils;

public class SqlFieldUtil {
    public static List<Class<?>> getSqlSuperClasss() {
        LinkedList result = new LinkedList();
        result.add(Byte.class);
        result.add(Character.class);
        result.add(Short.class);
        result.add(Boolean.class);
        result.add(Integer.class);
        result.add(Long.class);
        result.add(Float.class);
        result.add(Double.class);
        result.add(BigDecimal.class);
        result.add(Number.class);
        result.add(String.class);
        result.add(Enum.class);
        result.add(Blob.class);
        result.add(java.util.Date.class);
        result.add(Byte[].class);
        result.add(Byte.TYPE);
        result.add(Character.TYPE);
        result.add(Short.TYPE);
        result.add(Boolean.TYPE);
        result.add(Integer.TYPE);
        result.add(Long.TYPE);
        result.add(Float.TYPE);
        result.add(Double.TYPE);
        result.add(byte[].class);
        return result;
    }

    public static List<Field> getAllSqlSupportFields(Class<?> objClass) {
        List<Field> fields = FieldUtil.getAllFields(objClass);
        LinkedList<Field> result = new LinkedList<Field>();
        List<Class<?>> sqlSuperClasss = SqlFieldUtil.getSqlSuperClasss();
        block0: for (Field field : fields) {
            for (Class<?> superClass : sqlSuperClasss) {
                if (!superClass.isAssignableFrom(field.getType())) continue;
                result.add(field);
                continue block0;
            }
        }
        return result;
    }

    public static boolean isFacultyOfString(Class<?> type) {
        return String.class.isAssignableFrom(type);
    }

    public static boolean isFacultyOfDate(Class<?> type) {
        return java.util.Date.class.isAssignableFrom(type);
    }

    public static boolean isFacultyOfNumber(Class<?> type) {
        if (Number.class.isAssignableFrom(type)) {
            return true;
        }
        if (Byte.TYPE.isAssignableFrom(type)) {
            return true;
        }
        if (Short.TYPE.isAssignableFrom(type)) {
            return true;
        }
        if (Integer.TYPE.isAssignableFrom(type)) {
            return true;
        }
        if (Long.TYPE.isAssignableFrom(type)) {
            return true;
        }
        if (Float.TYPE.isAssignableFrom(type)) {
            return true;
        }
        return Double.TYPE.isAssignableFrom(type);
    }

    public static boolean isFacultyOfBlob(Class<?> type) {
        if (Blob.class.isAssignableFrom(type)) {
            return true;
        }
        if (byte[].class.isAssignableFrom(type)) {
            return true;
        }
        return Byte[].class.isAssignableFrom(type);
    }

    public static boolean isFacultyOfEnum(Class<?> type) {
        return Enum.class.isAssignableFrom(type);
    }

    public static boolean isFacultyOfBoolean(Class<?> type) {
        if (Boolean.class.isAssignableFrom(type)) {
            return true;
        }
        return Boolean.TYPE.isAssignableFrom(type);
    }

    public static boolean isFacultyOfChar(Class<?> type) {
        if (Character.TYPE.isAssignableFrom(type)) {
            return true;
        }
        return Character.class.isAssignableFrom(type);
    }

    public static void setFieldValue(String column, Object entity, Object value) {
        if (value == null) {
            return;
        }
        EntityInfo.FieldInfo fieldInfo = UniversalCrudContent.getEntityInfo(entity.getClass()).getColumnMapFieldInfo().get(column);
        if (fieldInfo != null) {
            Field field = fieldInfo.getField();
            if (SqlFieldUtil.isFacultyOfString(field.getType())) {
                FieldUtil.setField(entity, field, value.toString());
            } else if (SqlFieldUtil.isFacultyOfDate(field.getType())) {
                long timestamp = 0L;
                if (SqlFieldUtil.isFacultyOfDate(value.getClass())) {
                    timestamp = ((java.util.Date)value).getTime();
                } else if (SqlFieldUtil.isFacultyOfNumber(value.getClass())) {
                    timestamp = ((Number)value).longValue();
                } else {
                    throw new ClassCastException(value.getClass().getName() + " can't cast to " + field.getType().getName());
                }
                if (Date.class.isAssignableFrom(field.getType())) {
                    FieldUtil.setField(entity, field, new Date(timestamp));
                } else if (Timestamp.class.isAssignableFrom(field.getType())) {
                    FieldUtil.setField(entity, field, new Timestamp(timestamp));
                } else if (Time.class.isAssignableFrom(field.getType())) {
                    FieldUtil.setField(entity, field, new Time(timestamp));
                } else if (java.util.Date.class.isAssignableFrom(field.getType())) {
                    FieldUtil.setField(entity, field, new java.util.Date(timestamp));
                }
            } else if (SqlFieldUtil.isFacultyOfNumber(field.getType())) {
                Number number = (Number)value;
                if (BigDecimal.class.isAssignableFrom(field.getType())) {
                    FieldUtil.setField(entity, field, new BigDecimal(number.toString()));
                } else if (Byte.TYPE.isAssignableFrom(field.getType()) || Byte.class.isAssignableFrom(field.getType())) {
                    FieldUtil.setField(entity, field, number.byteValue());
                } else if (Short.TYPE.isAssignableFrom(field.getType()) || Short.class.isAssignableFrom(field.getType())) {
                    FieldUtil.setField(entity, field, number.shortValue());
                } else if (Integer.TYPE.isAssignableFrom(field.getType()) || Integer.class.isAssignableFrom(field.getType())) {
                    FieldUtil.setField(entity, field, number.intValue());
                } else if (Long.TYPE.isAssignableFrom(field.getType()) || Long.class.isAssignableFrom(field.getType())) {
                    FieldUtil.setField(entity, field, number.longValue());
                } else if (Float.TYPE.isAssignableFrom(field.getType()) || Float.class.isAssignableFrom(field.getType())) {
                    FieldUtil.setField(entity, field, Float.valueOf(number.floatValue()));
                } else if (Double.TYPE.isAssignableFrom(field.getType()) || Double.class.isAssignableFrom(field.getType())) {
                    FieldUtil.setField(entity, field, number.doubleValue());
                }
            } else if (SqlFieldUtil.isFacultyOfBlob(field.getType())) {
                field.setAccessible(true);
                if (Blob.class.isAssignableFrom(value.getClass())) {
                    Blob blob = (Blob)value;
                    if (Blob.class.isAssignableFrom(field.getType())) {
                        FieldUtil.setField(entity, field, value);
                    } else if (Byte[].class.isAssignableFrom(field.getType())) {
                        try {
                            byte[] byteb = StreamUtils.copyToByteArray((InputStream)blob.getBinaryStream());
                            Byte[] bin = new Byte[byteb.length];
                            for (int i = 0; i < bin.length; ++i) {
                                bin[i] = byteb[i];
                            }
                            FieldUtil.setField(entity, field, new Object[]{bin});
                        }
                        catch (Exception e) {
                            throw new IllegalArgumentException(e);
                        }
                    } else if (byte[].class.isAssignableFrom(field.getType())) {
                        try {
                            FieldUtil.setField(entity, field, new Object[]{StreamUtils.copyToByteArray((InputStream)blob.getBinaryStream())});
                        }
                        catch (IOException | SQLException e) {
                            throw new IllegalArgumentException(e);
                        }
                    }
                } else if (Byte[].class.isAssignableFrom(value.getClass())) {
                    if (Byte[].class.isAssignableFrom(field.getType())) {
                        FieldUtil.setField(entity, field, value);
                    } else if (byte[].class.isAssignableFrom(field.getType())) {
                        Byte[] byteb = (Byte[])value;
                        byte[] bin = new byte[byteb.length];
                        for (int i = 0; i < bin.length; ++i) {
                            bin[i] = byteb[i];
                        }
                        FieldUtil.setField(entity, field, new Object[]{bin});
                    } else if (SerialBlob.class.isAssignableFrom(field.getType())) {
                        Byte[] byteb = (Byte[])value;
                        byte[] bin = new byte[byteb.length];
                        for (int i = 0; i < bin.length; ++i) {
                            bin[i] = byteb[i];
                        }
                        try {
                            SerialBlob serialBlob = new SerialBlob(bin);
                            FieldUtil.setField(entity, field, serialBlob);
                        }
                        catch (SQLException e) {
                            throw new RuntimeException(e);
                        }
                    }
                } else if (byte[].class.isAssignableFrom(value.getClass())) {
                    if (byte[].class.isAssignableFrom(field.getType())) {
                        FieldUtil.setField(entity, field, value);
                    } else if (Byte[].class.isAssignableFrom(field.getType())) {
                        byte[] byteb = (byte[])value;
                        Byte[] bin = new Byte[byteb.length];
                        for (int i = 0; i < bin.length; ++i) {
                            bin[i] = byteb[i];
                        }
                        FieldUtil.setField(entity, field, new Object[]{bin});
                    } else if (SerialBlob.class.isAssignableFrom(field.getType())) {
                        try {
                            SerialBlob serialBlob = new SerialBlob((byte[])value);
                            FieldUtil.setField(entity, field, serialBlob);
                        }
                        catch (SQLException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
            } else if (SqlFieldUtil.isFacultyOfEnum(field.getType())) {
                Class<?> enumType = field.getType();
                if (value instanceof String) {
                    FieldUtil.setField(entity, field, Enum.valueOf(enumType, (String)value));
                } else if (SqlFieldUtil.isFacultyOfNumber(value.getClass())) {
                    Enum[] enums;
                    int ordinal = ((Number)value).intValue();
                    for (Enum tempEnum : enums = (Enum[])enumType.getEnumConstants()) {
                        if (tempEnum.ordinal() != ordinal) continue;
                        FieldUtil.setField(entity, field, tempEnum);
                        break;
                    }
                }
            } else if (SqlFieldUtil.isFacultyOfBoolean(field.getType())) {
                if (value instanceof String) {
                    String strValue = ((String)value).toLowerCase();
                    if (!(strValue.equals("yes") || strValue.equals("no") || strValue.equals("true") || strValue.equals("false"))) {
                        throw new ClassCastException("can't cast " + strValue + " to boolean");
                    }
                    if (strValue.equals("yes") || strValue.equals("true")) {
                        FieldUtil.setField(entity, field, true);
                    } else if (strValue.equals("no") || strValue.equals("false")) {
                        FieldUtil.setField(entity, field, false);
                    }
                } else if (SqlFieldUtil.isFacultyOfNumber(value.getClass())) {
                    int intValue = ((Number)value).intValue();
                    if (intValue != 0) {
                        FieldUtil.setField(entity, field, true);
                    } else {
                        FieldUtil.setField(entity, field, false);
                    }
                }
            } else if (SqlFieldUtil.isFacultyOfChar(field.getType())) {
                if (value instanceof String) {
                    FieldUtil.setField(entity, field, Character.valueOf(((String)value).charAt(0)));
                } else if (SqlFieldUtil.isFacultyOfNumber(value.getClass())) {
                    int intValue = ((Number)value).intValue();
                    FieldUtil.setField(entity, field, Character.valueOf((char)intValue));
                }
            }
        }
    }
}

