/*
 * Decompiled with CFR 0.152.
 */
package org.linuxprobe.crud.utils;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class FieldUtil {
    public static List<Field> getAllFields(Class<?> objClass) {
        objClass = FieldUtil.getRealCalssOfProxyClass(objClass);
        List<Field> fields = Arrays.asList(objClass.getDeclaredFields());
        fields = new ArrayList<Field>(fields);
        Class<?> superClass = objClass.getSuperclass();
        if (superClass != null) {
            while (!superClass.equals(Object.class)) {
                fields.addAll(Arrays.asList(superClass.getDeclaredFields()));
                superClass = superClass.getSuperclass();
            }
        }
        return fields;
    }

    public static Method getMethodOfFieldSet(Class<?> objClass, Field field) {
        if (objClass == null || field == null) {
            return null;
        }
        objClass = FieldUtil.getRealCalssOfProxyClass(objClass);
        String fieldName = field.getName();
        String funSuffix = fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
        Method methodOfSet = null;
        try {
            methodOfSet = objClass.getMethod("set" + funSuffix, field.getType());
        }
        catch (NoSuchMethodException | SecurityException exception) {
            // empty catch block
        }
        return methodOfSet;
    }

    public static Method getMethodOfFieldGet(Class<?> objClass, Field field) {
        if (objClass == null || field == null) {
            return null;
        }
        objClass = FieldUtil.getRealCalssOfProxyClass(objClass);
        String fieldName = field.getName();
        String prefix = "get";
        String funSuffix = fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
        if (Boolean.TYPE.isAssignableFrom(field.getType())) {
            if (fieldName.matches("^is[A-Z0-9_]+.*$")) {
                prefix = "";
                funSuffix = fieldName;
            } else {
                prefix = "is";
            }
        }
        Method methodOfGet = null;
        try {
            methodOfGet = objClass.getMethod(prefix + funSuffix, new Class[0]);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new IllegalArgumentException(e);
        }
        return methodOfGet;
    }

    public static void setField(Object obj, Field field, Object ... arg) {
        Class<?> objClass = FieldUtil.getRealCalssOfProxyClass(obj.getClass());
        Method methodOfSet = FieldUtil.getMethodOfFieldSet(objClass, field);
        if (methodOfSet != null) {
            try {
                methodOfSet.invoke(obj, arg);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    public static Object getFieldValue(Object obj, Field field) {
        Class<?> objClass = FieldUtil.getRealCalssOfProxyClass(obj.getClass());
        Method getMethod = FieldUtil.getMethodOfFieldGet(objClass, field);
        getMethod.setAccessible(true);
        try {
            Object value = getMethod.invoke(obj, new Object[0]);
            return value;
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static Object getFieldValueByFieldName(Object obj, String fieldName) {
        Class<?> objClass = FieldUtil.getRealCalssOfProxyClass(obj.getClass());
        Field field = null;
        try {
            field = objClass.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException | SecurityException e1) {
            throw new RuntimeException(e1);
        }
        Method getMethod = FieldUtil.getMethodOfFieldGet(objClass, field);
        getMethod.setAccessible(true);
        try {
            Object value = getMethod.invoke(obj, new Object[0]);
            return value;
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String getFieldNameByMethod(Method method) {
        String fieldName = method.getName().substring(3, method.getName().length());
        fieldName = fieldName.substring(0, 1).toLowerCase() + fieldName.substring(1, fieldName.length());
        return fieldName;
    }

    public static Field getFieldByMethod(Class<?> type, Method method) {
        type = FieldUtil.getRealCalssOfProxyClass(type);
        String fieldName = FieldUtil.getFieldNameByMethod(method);
        return FieldUtil.getDeclaredField(type, fieldName);
    }

    public static Class<?> getRealCalssOfProxyClass(Class<?> type) {
        while (type.getSimpleName().indexOf("$$EnhancerByCGLIB$$") != -1) {
            type = type.getSuperclass();
        }
        return type;
    }

    public static Field getDeclaredField(Class<?> type, String fieldName) {
        List<Field> fields = FieldUtil.getAllFields(type);
        for (Field field : fields) {
            if (!field.getName().equals(fieldName)) continue;
            return field;
        }
        return null;
    }

    public static Class<?> getGenericSuperclass(Class<?> clazz, int order) {
        Type type = ((ParameterizedType)clazz.getGenericSuperclass()).getActualTypeArguments()[order];
        Class<?> genericsCalss = null;
        try {
            genericsCalss = Class.forName(type.getTypeName());
            return genericsCalss;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static Type getGenericSuperType(Class<?> clazz, int order) {
        Type type = ((ParameterizedType)clazz.getGenericSuperclass()).getActualTypeArguments()[order];
        return type;
    }

    public static Class<?> getFiledGenericclass(Field field, int order) {
        ParameterizedType parameterizedType = (ParameterizedType)field.getGenericType();
        if (parameterizedType == null) {
            throw new IllegalArgumentException("\u5fc5\u987b\u6307\u5b9a\u6cdb\u578b\u7c7b\u578b");
        }
        Type type = parameterizedType.getActualTypeArguments()[0];
        Class<?> genericsCalss = null;
        try {
            genericsCalss = Class.forName(type.getTypeName());
            return genericsCalss;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static boolean isProxyClass(Class<?> clazz) {
        return clazz.getSimpleName().indexOf("$$EnhancerByCGLIB$$") != -1;
    }
}

