/*
 * Decompiled with CFR 0.152.
 */
package org.linuxprobe.crud.service.impl;

import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import org.linuxprobe.crud.core.content.UniversalCrudContent;
import org.linuxprobe.crud.core.query.BaseQuery;
import org.linuxprobe.crud.core.query.Page;
import org.linuxprobe.crud.mybatis.spring.UniversalCrudSqlSessionTemplate;
import org.linuxprobe.crud.service.UniversalService;
import org.linuxprobe.crud.utils.FieldUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class UniversalServiceImpl<Model, IdType extends Serializable, Query extends BaseQuery>
implements UniversalService<Model, IdType, Query> {
    @Autowired
    public UniversalCrudSqlSessionTemplate sqlSessionTemplate;

    private Class<?> getModelCalss() {
        Type type = FieldUtil.getGenericSuperType(this.getClass(), 0);
        return UniversalCrudContent.getEntityInfo(type.getTypeName()).getEntityType();
    }

    @Override
    @Transactional
    public Model save(Model model) {
        return this.sqlSessionTemplate.insert(model);
    }

    @Override
    @Transactional
    public List<Model> batchSave(List<Model> models) {
        return this.sqlSessionTemplate.batchInsert(models);
    }

    @Override
    @Transactional
    public int removeByPrimaryKey(IdType id) {
        Class<?> modelClass = this.getModelCalss();
        return this.sqlSessionTemplate.deleteByPrimaryKey((Serializable)id, modelClass);
    }

    @Override
    @Transactional
    public long batchRemoveByPrimaryKey(List<IdType> ids) throws Exception {
        Class<?> modelClass = this.getModelCalss();
        return this.sqlSessionTemplate.batchDeleteByPrimaryKey(ids, modelClass);
    }

    @Override
    @Transactional
    public int remove(Model record) {
        return this.sqlSessionTemplate.delete(record);
    }

    @Override
    @Transactional
    public int batchRemove(List<Model> records) {
        return this.sqlSessionTemplate.batchDelete(records);
    }

    @Override
    public Model getByPrimaryKey(IdType id) {
        Class<?> modelClass = this.getModelCalss();
        Object model = this.sqlSessionTemplate.selectByPrimaryKey((Serializable)id, modelClass);
        return (Model)model;
    }

    @Override
    public List<Model> getByQueryParam(Query param) {
        return this.sqlSessionTemplate.universalSelect((BaseQuery)param);
    }

    @Override
    public long getCountByQueryParam(Query param) {
        return this.sqlSessionTemplate.selectCount((BaseQuery)param);
    }

    @Override
    public Page<Model> getPageInfo(Query param) {
        Page<Model> result = new Page<Model>();
        result.setCurrentPage(((BaseQuery)param).getLimit().getCurrentPage());
        result.setPageSize(((BaseQuery)param).getLimit().getPageSize());
        result.setData(this.getByQueryParam(param));
        result.setTotal(this.getCountByQueryParam(param));
        return result;
    }

    @Override
    public List<Map<String, Object>> getBySql(String sql) {
        return this.sqlSessionTemplate.selectBySql(sql);
    }

    @Override
    public Map<String, Object> getOneBySql(String sql) {
        return this.sqlSessionTemplate.selectOneBySql(sql);
    }

    @Override
    public <T> List<T> getBySql(String sql, Class<T> type) {
        return this.sqlSessionTemplate.selectBySql(sql, type);
    }

    @Override
    public <T> T getOneBySql(String sql, Class<T> type) {
        return this.sqlSessionTemplate.selectOneBySql(sql, type);
    }

    @Override
    public List<Model> getByColumn(String column, Serializable columnValue) {
        return this.sqlSessionTemplate.selectByColumn(column, columnValue, this.getModelCalss());
    }

    @Override
    public List<Model> getByFiled(String fieldName, Serializable fieldValue) {
        return this.sqlSessionTemplate.selectByField(fieldName, fieldValue, this.getModelCalss());
    }

    @Override
    public Model getOneByColumn(String column, Serializable columnValue) {
        return (Model)this.sqlSessionTemplate.selectOneByColumn(column, columnValue, this.getModelCalss());
    }

    @Override
    public Model getOneByFiled(String fieldName, Serializable fieldValue) {
        return (Model)this.sqlSessionTemplate.selectOneByField(fieldName, fieldValue, this.getModelCalss());
    }

    @Override
    @Transactional
    public Model globalUpdate(Model model) {
        return this.sqlSessionTemplate.globalUpdate(model);
    }

    @Override
    @Transactional
    public Model localUpdate(Model model) {
        return this.sqlSessionTemplate.localUpdate(model);
    }
}

