/*
 * Decompiled with CFR 0.152.
 */
package org.linuxprobe.crud.core.sql.generator.impl.mysql;

import java.util.List;
import org.linuxprobe.crud.core.annoatation.Column;
import org.linuxprobe.crud.core.content.EntityInfo;
import org.linuxprobe.crud.core.content.UniversalCrudContent;
import org.linuxprobe.crud.core.sql.generator.UpdateSqlGenerator;
import org.linuxprobe.crud.core.sql.generator.impl.mysql.MysqlFieldValueConversion;
import org.linuxprobe.crud.exception.OperationNotSupportedException;

public class MysqlUpdateSqlGenerator
implements UpdateSqlGenerator {
    @Override
    public String toGlobalUpdateSql(Object entity) {
        EntityInfo entityInfo = UniversalCrudContent.getEntityInfo(entity.getClass());
        if (entityInfo.getPrimaryKey() == null) {
            throw new OperationNotSupportedException(entity.getClass() + " cannot be without primary key, please use org.linuxprobe.crud.core.annoatation.PrimaryKey Mark the primary key");
        }
        String table = entityInfo.getTableName();
        String primaryKeyValue = MysqlFieldValueConversion.updateModelConversion(entity, entityInfo.getPrimaryKey().getField());
        if (primaryKeyValue == null) {
            throw new IllegalArgumentException("The primary key cannot be null");
        }
        if (String.class.isAssignableFrom(primaryKeyValue.getClass()) && primaryKeyValue.isEmpty()) {
            throw new IllegalArgumentException("The primary key cannot be empty");
        }
        StringBuilder sqlBuilder = new StringBuilder("UPDATE `" + table + "` SET ");
        List<EntityInfo.FieldInfo> fieldInfos = entityInfo.getFieldInfos();
        for (EntityInfo.FieldInfo fieldInfo : fieldInfos) {
            Column column;
            if (fieldInfo.getField().isAnnotationPresent(Column.class) && (column = fieldInfo.getField().getAnnotation(Column.class)).updateIgnore()) continue;
            String value = MysqlFieldValueConversion.updateModelConversion(entity, fieldInfo.getField());
            sqlBuilder.append("`" + fieldInfo.getColumnName() + "` = " + value + ", ");
        }
        if (sqlBuilder.indexOf(",") != -1) {
            sqlBuilder.replace(sqlBuilder.length() - 2, sqlBuilder.length(), " ");
        }
        sqlBuilder.append("WHERE `" + entityInfo.getPrimaryKey().getColumnName() + "` = " + primaryKeyValue);
        return sqlBuilder.toString();
    }

    @Override
    public String toLocalUpdateSql(Object entity) {
        EntityInfo entityInfo = UniversalCrudContent.getEntityInfo(entity.getClass());
        if (entityInfo.getPrimaryKey() == null) {
            throw new OperationNotSupportedException(entity.getClass() + " cannot be without primary key, please use org.linuxprobe.crud.core.annoatation.PrimaryKey Mark the primary key");
        }
        String table = entityInfo.getTableName();
        String primaryKeyValue = MysqlFieldValueConversion.updateModelConversion(entity, entityInfo.getPrimaryKey().getField());
        if (primaryKeyValue == null) {
            throw new IllegalArgumentException("The primary key cannot be null");
        }
        if (String.class.isAssignableFrom(primaryKeyValue.getClass()) && primaryKeyValue.isEmpty()) {
            throw new IllegalArgumentException("The primary key cannot be empty");
        }
        StringBuilder sqlBuilder = new StringBuilder("UPDATE `" + table + "` SET ");
        List<EntityInfo.FieldInfo> fieldInfos = entityInfo.getFieldInfos();
        for (EntityInfo.FieldInfo fieldInfo : fieldInfos) {
            String value;
            Column column;
            if (fieldInfo.getField().isAnnotationPresent(Column.class) && (column = fieldInfo.getField().getAnnotation(Column.class)).updateIgnore() || (value = MysqlFieldValueConversion.updateModelConversion(entity, fieldInfo.getField())) == null) continue;
            sqlBuilder.append("`" + fieldInfo.getColumnName() + "` = " + value + ", ");
        }
        if (sqlBuilder.indexOf(",") != -1) {
            sqlBuilder.replace(sqlBuilder.length() - 2, sqlBuilder.length(), " ");
        }
        sqlBuilder.append("WHERE `" + entityInfo.getPrimaryKey().getColumnName() + "` = " + primaryKeyValue);
        return sqlBuilder.toString();
    }
}

