/*
 * Decompiled with CFR 0.152.
 */
package org.linuxprobe.crud.core.sql.generator.impl.mysql;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;
import org.linuxprobe.crud.core.annoatation.BlobHandler;
import org.linuxprobe.crud.core.annoatation.BooleanHandler;
import org.linuxprobe.crud.core.annoatation.CharHandler;
import org.linuxprobe.crud.core.annoatation.Column;
import org.linuxprobe.crud.core.annoatation.DateHandler;
import org.linuxprobe.crud.core.annoatation.EnumHandler;
import org.linuxprobe.crud.core.annoatation.NumberHandler;
import org.linuxprobe.crud.core.annoatation.PrimaryKey;
import org.linuxprobe.crud.core.annoatation.StringHandler;
import org.linuxprobe.crud.exception.OperationNotSupportedException;
import org.linuxprobe.crud.utils.FieldUtil;
import org.linuxprobe.crud.utils.SqlEscapeUtil;
import org.linuxprobe.crud.utils.SqlFieldUtil;
import org.springframework.util.StreamUtils;

public class MysqlFieldValueConversion {
    private static String getStringValue(Object record, Field field, boolean enalbeCheckRule) {
        Column column;
        String fieldValue = (String)FieldUtil.getFieldValue(record, field);
        if (enalbeCheckRule && field.isAnnotationPresent(Column.class) && (column = field.getAnnotation(Column.class)).notNull() && fieldValue == null) {
            throw new IllegalArgumentException("in " + record.getClass().getName() + "," + field.getName() + " can't be null");
        }
        if (fieldValue != null) {
            if (enalbeCheckRule && field.isAnnotationPresent(StringHandler.class)) {
                StringHandler stringHandler = field.getAnnotation(StringHandler.class);
                if (stringHandler.minLeng() > 0 && fieldValue.length() < stringHandler.minLeng()) {
                    throw new IllegalArgumentException("in " + record.getClass().getName() + "," + field.getName() + " minLeng is " + stringHandler.minLeng());
                }
                if (stringHandler.maxLeng() > 0 && fieldValue.length() > stringHandler.maxLeng()) {
                    throw new IllegalArgumentException("in " + record.getClass().getName() + "," + field.getName() + " maxLeng is " + stringHandler.maxLeng());
                }
                if (!stringHandler.regex().isEmpty() && !fieldValue.matches(stringHandler.regex())) {
                    throw new IllegalArgumentException("in " + record.getClass().getName() + ",the value " + fieldValue + " of " + field.getName() + " cannot match the regex " + stringHandler.regex());
                }
            }
            fieldValue = SqlEscapeUtil.mysqlEscape(fieldValue);
            fieldValue = "'" + fieldValue + "'";
        }
        return fieldValue;
    }

    private static String getDateValue(Object record, Field field, boolean enalbeCheckRule) {
        Column column;
        Date fieldValue = (Date)FieldUtil.getFieldValue(record, field);
        String result = null;
        if (enalbeCheckRule && field.isAnnotationPresent(Column.class) && (column = field.getAnnotation(Column.class)).notNull() && fieldValue == null) {
            throw new IllegalArgumentException("in " + record.getClass().getName() + "," + field.getName() + " can't be null");
        }
        if (fieldValue != null) {
            if (field.isAnnotationPresent(DateHandler.class)) {
                DateHandler dateHandler = field.getAnnotation(DateHandler.class);
                if (dateHandler.customerType().equals((Object)DateHandler.DateCustomerType.String)) {
                    SimpleDateFormat dateFormat = new SimpleDateFormat(dateHandler.pattern());
                    result = "'" + dateFormat.format(fieldValue) + "'";
                } else {
                    result = fieldValue.getTime() + "";
                }
            } else {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                result = "'" + dateFormat.format(fieldValue) + "'";
            }
        }
        return result;
    }

    private static String getEnumValue(Object record, Field field, boolean enalbeCheckRule) {
        Column column;
        Enum fieldValue = (Enum)FieldUtil.getFieldValue(record, field);
        if (enalbeCheckRule && field.isAnnotationPresent(Column.class) && (column = field.getAnnotation(Column.class)).notNull() && fieldValue == null) {
            throw new IllegalArgumentException("in " + record.getClass().getName() + "," + field.getName() + " can't be null");
        }
        String result = null;
        if (fieldValue != null) {
            EnumHandler enumHandler;
            result = fieldValue.ordinal() + "";
            if (field.isAnnotationPresent(EnumHandler.class) && (enumHandler = field.getAnnotation(EnumHandler.class)).value().equals((Object)EnumHandler.EnumCustomerType.Name)) {
                result = "'" + fieldValue.name() + "'";
            }
        }
        return result;
    }

    private static String getNumberValue(Object record, Field field, boolean enalbeCheckRule) {
        Column column;
        Number fieldValue = (Number)FieldUtil.getFieldValue(record, field);
        String result = null;
        if (enalbeCheckRule && field.isAnnotationPresent(Column.class) && (column = field.getAnnotation(Column.class)).notNull() && fieldValue == null) {
            throw new IllegalArgumentException("in " + record.getClass().getName() + "," + field.getName() + " can't be null");
        }
        if (fieldValue != null) {
            result = fieldValue + "";
            if (enalbeCheckRule && field.isAnnotationPresent(NumberHandler.class)) {
                BigDecimal bigDecimalMaxValue;
                BigDecimal bigDecimalMinValue;
                NumberHandler numberHandler = field.getAnnotation(NumberHandler.class);
                BigDecimal bigDecimalValue = new BigDecimal(result);
                if (!numberHandler.minValue().isEmpty() && (bigDecimalMinValue = new BigDecimal(numberHandler.minValue())).compareTo(bigDecimalValue) > 0) {
                    throw new IllegalArgumentException("in " + record.getClass().getName() + "," + field.getName() + " minValue is " + numberHandler.minValue());
                }
                if (!numberHandler.maxValue().isEmpty() && (bigDecimalMaxValue = new BigDecimal(numberHandler.maxValue())).compareTo(bigDecimalValue) < 0) {
                    throw new IllegalArgumentException("in " + record.getClass().getName() + "," + field.getName() + " maxValue is " + numberHandler.maxValue());
                }
            }
        }
        return result;
    }

    private static String getBooleanValue(Object record, Field field, boolean enalbeCheckRule) {
        Column column;
        Boolean fieldValue = (Boolean)FieldUtil.getFieldValue(record, field);
        if (enalbeCheckRule && field.isAnnotationPresent(Column.class) && (column = field.getAnnotation(Column.class)).notNull() && fieldValue == null) {
            throw new IllegalArgumentException("in " + record.getClass().getName() + "," + field.getName() + " can't be null");
        }
        String result = null;
        if (fieldValue != null) {
            result = fieldValue != false ? "1" : "0";
            if (field.isAnnotationPresent(BooleanHandler.class)) {
                BooleanHandler booleanHandler = field.getAnnotation(BooleanHandler.class);
                if (booleanHandler.value().equals((Object)BooleanHandler.BooleanCustomerType.YesAndNo)) {
                    result = fieldValue.booleanValue() ? "'yes'" : "'no'";
                } else if (booleanHandler.value().equals((Object)BooleanHandler.BooleanCustomerType.TrueAndFalse)) {
                    result = fieldValue != false ? "'true'" : "'false'";
                }
            }
        }
        return result;
    }

    private static String getCharValue(Object record, Field field, boolean enalbeCheckRule) {
        Column column;
        Character fieldValue = (Character)FieldUtil.getFieldValue(record, field);
        if (enalbeCheckRule && field.isAnnotationPresent(Column.class) && (column = field.getAnnotation(Column.class)).notNull() && fieldValue == null) {
            throw new IllegalArgumentException("in " + record.getClass().getName() + "," + field.getName() + " can't be null");
        }
        String result = null;
        if (fieldValue != null) {
            CharHandler charHandler;
            result = fieldValue.charValue() + "";
            if (enalbeCheckRule && field.isAnnotationPresent(CharHandler.class) && (charHandler = field.getAnnotation(CharHandler.class)).value().equals((Object)CharHandler.CharCustomerType.ToString)) {
                result = "'" + fieldValue + "'";
            }
        }
        return result;
    }

    private static String getBlobValue(Object record, Field field, boolean enalbeCheckRule) {
        Column column;
        Object fieldValue = FieldUtil.getFieldValue(record, field);
        if (enalbeCheckRule && field.isAnnotationPresent(Column.class) && (column = field.getAnnotation(Column.class)).notNull() && fieldValue == null) {
            throw new IllegalArgumentException("in " + record.getClass().getName() + "," + field.getName() + " can't be null");
        }
        String result = null;
        if (fieldValue != null) {
            byte[] bin = null;
            if (Blob.class.isAssignableFrom(field.getType())) {
                Blob blob = (Blob)fieldValue;
                try {
                    bin = StreamUtils.copyToByteArray((InputStream)blob.getBinaryStream());
                }
                catch (IOException | SQLException e) {
                    throw new IllegalArgumentException(e);
                }
            } else if (byte[].class.isAssignableFrom(field.getType())) {
                bin = (byte[])fieldValue;
            } else if (Byte[].class.isAssignableFrom(field.getType())) {
                Byte[] binB = (Byte[])fieldValue;
                bin = new byte[binB.length];
                for (int i = 0; i < binB.length; ++i) {
                    bin[i] = binB[i];
                }
            }
            if (enalbeCheckRule && field.isAnnotationPresent(BlobHandler.class)) {
                BlobHandler blobHandler = field.getAnnotation(BlobHandler.class);
                if (blobHandler.minSize() != 0 && bin.length < blobHandler.minSize()) {
                    throw new IllegalArgumentException("in " + record.getClass().getName() + "," + field.getName() + " minSize is " + blobHandler.minSize());
                }
                if (blobHandler.maxSize() != 0 && bin.length > blobHandler.maxSize()) {
                    throw new IllegalArgumentException("in " + record.getClass().getName() + "," + field.getName() + " maxSize is " + blobHandler.maxSize());
                }
            }
            try {
                result = new String(bin, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            result = SqlEscapeUtil.mysqlEscape(result);
            result = "'" + result + "'";
            result = "CONVERT( " + result + ", BINARY )";
        }
        return result;
    }

    public static String conversion(Object entity, Field field, boolean enalbeCheckRule) {
        String result = null;
        if (SqlFieldUtil.isFacultyOfString(field.getType())) {
            result = MysqlFieldValueConversion.getStringValue(entity, field, enalbeCheckRule);
        } else if (SqlFieldUtil.isFacultyOfNumber(field.getType())) {
            result = MysqlFieldValueConversion.getNumberValue(entity, field, enalbeCheckRule);
        } else if (SqlFieldUtil.isFacultyOfBoolean(field.getType())) {
            result = MysqlFieldValueConversion.getBooleanValue(entity, field, enalbeCheckRule);
        } else if (SqlFieldUtil.isFacultyOfDate(field.getType())) {
            result = MysqlFieldValueConversion.getDateValue(entity, field, enalbeCheckRule);
        } else if (SqlFieldUtil.isFacultyOfEnum(field.getType())) {
            result = MysqlFieldValueConversion.getEnumValue(entity, field, enalbeCheckRule);
        } else if (SqlFieldUtil.isFacultyOfChar(field.getType())) {
            result = MysqlFieldValueConversion.getCharValue(entity, field, enalbeCheckRule);
        } else if (SqlFieldUtil.isFacultyOfBlob(field.getType())) {
            result = MysqlFieldValueConversion.getBlobValue(entity, field, enalbeCheckRule);
        }
        return result;
    }

    public static String deleteModelConversion(Object entity, Field field) {
        String result = null;
        result = MysqlFieldValueConversion.conversion(entity, field, false);
        return result;
    }

    public static String updateModelConversion(Object entity, Field field) {
        String result = null;
        result = MysqlFieldValueConversion.conversion(entity, field, true);
        return result;
    }

    public static String insertModelConversion(Object entity, Field field) {
        String result = MysqlFieldValueConversion.updateModelConversion(entity, field);
        if (field.isAnnotationPresent(PrimaryKey.class) && result == null) {
            PrimaryKey primaryKey = field.getAnnotation(PrimaryKey.class);
            if (primaryKey.value().equals((Object)PrimaryKey.Strategy.UUID)) {
                try {
                    String uuid = UUID.randomUUID().toString().replaceAll("-", "");
                    FieldUtil.setField(entity, field, uuid);
                    result = "'" + uuid + "'";
                }
                catch (Exception e) {
                    throw new OperationNotSupportedException("\u672a\u627e\u5230\u4e3b\u952e\u7684set\u65b9\u6cd5", e);
                }
            } else if (primaryKey.value().equals((Object)PrimaryKey.Strategy.ASSIGNED)) {
                throw new NullPointerException("primaryKey can't not be null");
            }
        }
        return result;
    }
}

